/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.server;

import com.google.common.collect.Lists;
import io.gitlab.jfronny.commons.ref.WeakSet;
import io.gitlab.jfronny.respackopts.Respackopts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.WorldData;

public class ServerInstanceHolder {
    private static final Set<MinecraftServer> SERVERS = new WeakSet();

    public static void onServerStarted(MinecraftServer server) {
        if (!SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Multiple servers started at once. This is unexpected", new Object[0]);
        }
        if (!SERVERS.add(server)) {
            Respackopts.LOGGER.warn("Called SERVER_STARTED on a server that is already started", new Object[0]);
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        if (!SERVERS.remove(server)) {
            Respackopts.LOGGER.warn("Called SERVER_STOPPED on a server that was never started/already stopped", new Object[0]);
        }
        if (!SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Server stopped but another one is still running. This is unexpected", new Object[0]);
        }
    }

    public static void reloadResources() {
        if (SERVERS.isEmpty()) {
            Respackopts.LOGGER.warn("Attempted to reload resources while no server is running. Skipping", new Object[0]);
        }
        for (MinecraftServer server : SERVERS) {
            PackRepository manager = server.getPackRepository();
            WorldData saveProperties = server.getWorldData();
            ArrayList enabled = Lists.newArrayList((Iterable)manager.getSelectedIds());
            manager.reload();
            List disabled = saveProperties.getDataConfiguration().dataPacks().getDisabled();
            for (String name : manager.getAvailableIds()) {
                if (disabled.contains(name) || enabled.contains(name)) continue;
                enabled.add(name);
            }
            server.reloadResources((Collection)enabled).exceptionally(throwable -> {
                Respackopts.LOGGER.warn("Failed to reload data packs", throwable);
                return null;
            });
        }
    }
}

