/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CopyQueue<T>
implements Iterable<T> {
    private final Object[] array;
    private static final CopyQueue<?> EMPTY = new CopyQueue<Object>(new Object[0]);

    public CopyQueue(T[] array) {
        this.array = Objects.requireNonNull(array);
    }

    @SafeVarargs
    public static <T> CopyQueue<T> of(T ... array) {
        return array.length == 0 ? CopyQueue.empty() : new CopyQueue<T>(array);
    }

    public static <T> CopyQueue<T> empty() {
        return EMPTY;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return CopyQueue.this.array.length > this.i;
            }

            @Override
            public T next() {
                if (this.i >= CopyQueue.this.array.length) {
                    throw new NoSuchElementException();
                }
                return CopyQueue.this.array[this.i++];
            }
        };
    }

    public CopyQueue<T> push(T element) {
        Object[] newArray = new Object[this.array.length + 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        newArray[this.array.length] = element;
        return new CopyQueue<Object>(newArray);
    }

    public String toString() {
        return "CopyQueue" + Arrays.toString(this.array);
    }
}

