/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import io.gitlab.jfronny.respackopts.model.DiscoveredPack;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;

public class FallbackI18n {
    private static final Map<String, String> translations = new HashMap<String, String>();

    public static void prepare(List<DiscoveredPack> discoveredPacks) {
        translations.clear();
        for (DiscoveredPack pack : discoveredPacks) {
            try {
                PackResources rpi = pack.profile().open();
                try {
                    if (rpi == null) continue;
                    translations.putAll(FallbackI18n.loadFrom(rpi, pack.meta().id));
                }
                finally {
                    if (rpi == null) continue;
                    rpi.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private static Map<String, String> loadFrom(PackResources pack, String packId) {
        HashMap<String, String> translations = new HashMap<String, String>();
        for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
            IoSupplier translation = pack.getResource(PackType.CLIENT_RESOURCES, ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"lang/en_us.json"));
            if (translation == null) continue;
            try {
                InputStream is = (InputStream)translation.get();
                try {
                    Language.loadFromJson((InputStream)is, (key, value) -> {
                        if (key.startsWith("rpo." + packId + ".")) {
                            translations.put((String)key, (String)value);
                        }
                    });
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return translations;
    }

    public static void insertInto(Map<String, String> target) {
        translations.forEach(target::putIfAbsent);
    }
}

