/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.nametag;

import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.senseiwells.nametag.impl.NametagCommand;
import me.senseiwells.nametag.impl.PlaceholderNametag;
import me.senseiwells.nametag.impl.config.NametagConfig;
import me.senseiwells.nametag.impl.placeholder.ExtraPlayerPlaceholders;
import me.senseiwells.nametag.impl.predicate.ExtraPredicates;
import net.casual.arcade.commands.CommandTree;
import net.casual.arcade.commands.CommandUtilsKt;
import net.casual.arcade.events.GlobalEventHandler;
import net.casual.arcade.events.ListenerRegistry;
import net.casual.arcade.events.server.ServerRegisterCommandEvent;
import net.casual.arcade.events.server.ServerStartEvent;
import net.casual.arcade.events.server.player.PlayerJoinEvent;
import net.casual.arcade.events.threading.ThreadingStrategy;
import net.casual.arcade.events.threading.ThreadingTarget;
import net.casual.arcade.nametags.Nametag;
import net.casual.arcade.nametags.extensions.EntityNametagExtension;
import net.casual.arcade.utils.JsonUtils;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0003R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lme/senseiwells/nametag/CustomNameTags;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lnet/minecraft/class_2960;", "id", "Lme/senseiwells/nametag/impl/PlaceholderNametag;", "nametag", "addNametag", "(Lnet/minecraft/class_2960;Lme/senseiwells/nametag/impl/PlaceholderNametag;)V", "removeNametag", "(Lnet/minecraft/class_2960;)Lme/senseiwells/nametag/impl/PlaceholderNametag;", "", "getNametagIds", "()Ljava/util/Set;", "", "getNametags", "()Ljava/util/Collection;", "Lnet/minecraft/server/MinecraftServer;", "server", "readConfig", "(Lnet/minecraft/server/MinecraftServer;)V", "writeConfig", "migrateOldConfigs", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configPath", "Ljava/nio/file/Path;", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "Lme/senseiwells/nametag/impl/config/NametagConfig;", "config", "Lme/senseiwells/nametag/impl/config/NametagConfig;", "CustomNameTags"})
@SourceDebugExtension(value={"SMAP\nCustomNameTags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomNameTags.kt\nme/senseiwells/nametag/CustomNameTags\n+ 2 ListenerRegistry.kt\nnet/casual/arcade/events/ListenerRegistry$Companion\n*L\n1#1,107:1\n104#2,2:108\n104#2,2:110\n104#2,2:112\n*S KotlinDebug\n*F\n+ 1 CustomNameTags.kt\nme/senseiwells/nametag/CustomNameTags\n*L\n38#1:108,2\n41#1:110,2\n44#1:112,2\n*E\n"})
public final class CustomNameTags
implements ModInitializer {
    @NotNull
    public static final CustomNameTags INSTANCE = new CustomNameTags();
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("custom-nametags");
    @NotNull
    private static final Logger logger;
    private static NametagConfig config;

    private CustomNameTags() {
    }

    public void onInitialize() {
        ListenerRegistry $this$register$iv;
        ExtraPlayerPlaceholders.INSTANCE.register$CustomNameTags();
        ExtraPredicates.INSTANCE.register$CustomNameTags();
        this.migrateOldConfigs();
        ListenerRegistry.Companion companion = ListenerRegistry.Companion;
        ListenerRegistry listenerRegistry = (ListenerRegistry)GlobalEventHandler.Server;
        Consumer<ServerStartEvent> listener$iv = CustomNameTags::onInitialize$lambda$0;
        boolean $i$f$register = false;
        $this$register$iv.register(ServerStartEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        ListenerRegistry.Companion this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = CustomNameTags::onInitialize$lambda$1;
        $i$f$register = false;
        $this$register$iv.register(ServerRegisterCommandEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
        this_$iv = ListenerRegistry.Companion;
        $this$register$iv = (ListenerRegistry)GlobalEventHandler.Server;
        listener$iv = CustomNameTags::onInitialize$lambda$2;
        $i$f$register = false;
        $this$register$iv.register(PlayerJoinEvent.class, 1000, "default", (ThreadingStrategy)ThreadingTarget.Default, listener$iv);
    }

    public final void addNametag(@NotNull class_2960 id, @NotNull PlaceholderNametag nametag) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nametag, (String)"nametag");
        NametagConfig nametagConfig = config;
        if (nametagConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            nametagConfig = null;
        }
        nametagConfig.getNametags().put(id, nametag);
    }

    @Nullable
    public final PlaceholderNametag removeNametag(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        NametagConfig nametagConfig = config;
        if (nametagConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            nametagConfig = null;
        }
        return nametagConfig.getNametags().remove(id);
    }

    @NotNull
    public final Set<class_2960> getNametagIds() {
        NametagConfig nametagConfig = config;
        if (nametagConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            nametagConfig = null;
        }
        return nametagConfig.getNametags().keySet();
    }

    @NotNull
    public final Collection<PlaceholderNametag> getNametags() {
        NametagConfig nametagConfig = config;
        if (nametagConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            nametagConfig = null;
        }
        return nametagConfig.getNametags().values();
    }

    public final void readConfig(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path config = configPath.resolve("config.json");
        Intrinsics.checkNotNull((Object)config);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(config, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Generating default config");
            CustomNameTags.config = new NametagConfig(null, 1, null);
            this.writeConfig(server);
            return;
        }
        try {
            Object object = JsonUtils.INSTANCE.decodeWith((Decoder)NametagConfig.Companion.getCODEC(), config, (class_7225.class_7874)server.method_30611()).getOrThrow();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrThrow(...)");
            CustomNameTags.config = (NametagConfig)object;
        }
        catch (Exception e) {
            logger.error("Failed to read CustomNameTag config, generating default", (Throwable)e);
            CustomNameTags.config = new NametagConfig(null, 1, null);
        }
        this.writeConfig(server);
    }

    public final void writeConfig(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path config = configPath.resolve("config.json");
        try {
            Intrinsics.checkNotNull((Object)config);
            PathsKt.createParentDirectories((Path)config, (FileAttribute[])new FileAttribute[0]);
            NametagConfig nametagConfig = CustomNameTags.config;
            if (nametagConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                nametagConfig = null;
            }
            JsonUtils.INSTANCE.encodeWith((Object)nametagConfig, (Encoder)NametagConfig.Companion.getCODEC(), config, (class_7225.class_7874)server.method_30611());
        }
        catch (Exception e) {
            logger.error("Failed to write CustomNameTag config", (Throwable)e);
        }
    }

    private final void migrateOldConfigs() {
        Path oldPath = configPath.resolveSibling("CustomNameTags");
        try {
            Intrinsics.checkNotNull((Object)oldPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(oldPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path path = oldPath;
                Path path2 = configPath;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configPath");
                PathsKt.copyToRecursively$default((Path)path, (Path)path2, null, (boolean)true, (boolean)false, (int)2, null);
                PathsKt.deleteRecursively((Path)oldPath);
            }
        }
        catch (IOException e) {
            logger.error("Failed to migrate CustomNameTag configs!");
        }
    }

    private static final void onInitialize$lambda$0(ServerStartEvent serverStartEvent) {
        Intrinsics.checkNotNullParameter((Object)serverStartEvent, (String)"<destruct>");
        MinecraftServer server = serverStartEvent.component1();
        INSTANCE.readConfig(server);
    }

    private static final void onInitialize$lambda$1(ServerRegisterCommandEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommandTree[] commandTreeArray = new CommandTree[]{NametagCommand.INSTANCE};
        CommandUtilsKt.register((ServerRegisterCommandEvent)it, (CommandTree[])commandTreeArray);
    }

    private static final void onInitialize$lambda$2(PlayerJoinEvent playerJoinEvent) {
        Intrinsics.checkNotNullParameter((Object)playerJoinEvent, (String)"<destruct>");
        class_3222 player = playerJoinEvent.component1();
        for (PlaceholderNametag nametag : INSTANCE.getNametags()) {
            EntityNametagExtension.Companion.addNametag((class_1297)player, (Nametag)nametag);
        }
    }

    static {
        Logger logger = LogManager.getLogger((String)"CustomNameTags");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        CustomNameTags.logger = logger;
    }
}

