/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.core.config.OptionCategories;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;
import org.embeddedt.modernfix.screen.ModernFixOptionInfoScreen;

public class OptionList
extends ContainerObjectSelectionList<Entry> {
    private int maxNameWidth = 0;
    private static final int DEPTH_OFFSET = 20;
    private static final Component OPTION_ON = Component.translatable((String)"modernfix.option.on").withStyle(style -> style.withColor(ChatFormatting.GREEN));
    private static final Component OPTION_OFF = Component.translatable((String)"modernfix.option.off").withStyle(style -> style.withColor(ChatFormatting.RED));
    private static final Set<String> OPTIONS_MISSING_HELP = new HashSet<String>();
    private ModernFixConfigScreen mainScreen;
    private final Set<Option> addedOptions = new HashSet<Option>();

    private static MutableComponent getOptionComponent(Option option) {
        String friendlyKey = "modernfix.option.name." + option.getName();
        MutableComponent baseComponent = Component.literal((String)option.getSelfName());
        if (I18n.exists((String)friendlyKey)) {
            return Component.translatable((String)friendlyKey).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)baseComponent)));
        }
        return baseComponent;
    }

    public void updateOptionEntryStatuses() {
        for (Entry e : this.children()) {
            if (!(e instanceof OptionEntry)) continue;
            ((OptionEntry)e).updateStatus();
        }
    }

    private void addOption(Option option) {
        if (this.addedOptions.add(option)) {
            int w = this.minecraft.font.width((FormattedText)OptionList.getOptionComponent(option)) + 20 * option.getDepth();
            this.maxNameWidth = Math.max(w, this.maxNameWidth);
            this.addEntry((AbstractSelectionList.Entry)new OptionEntry(option.getName(), option));
            ModernFixMixinPlugin.instance.config.getOptionMap().values().stream().filter(subOption -> subOption.getParent() == option).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    public OptionList(ModernFixConfigScreen arg, Minecraft arg2) {
        super(arg2, arg.width + 45, arg.height - 52, 20, 20);
        this.mainScreen = arg;
        Multimap<String, Option> optionsByCategory = ModernFixMixinPlugin.instance.config.getOptionCategoryMap();
        List<String> theCategories = OptionCategories.getCategoriesInOrder();
        for (String category : theCategories) {
            String categoryTranslationKey = "modernfix.option.category." + category;
            this.addEntry((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.translatable((String)categoryTranslationKey).withStyle(Style.EMPTY.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)(categoryTranslationKey + ".description")))))));
            optionsByCategory.get((Object)category).stream().filter(key -> {
                int dotCount = 0;
                for (char c : key.getName().toCharArray()) {
                    if (c != '.') continue;
                    ++dotCount;
                }
                return dotCount >= 2;
            }).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    protected int scrollBarY() {
        return super.scrollBarY();
    }

    public int getRowWidth() {
        return super.getRowWidth() + 32;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int left = this.getRowLeft();
        int width = this.getRowWidth();
        int itemCount = this.children().size();
        for (int index = 0; index < itemCount; ++index) {
            int top = this.getRowTop(index);
            int bottom = this.getRowBottom(index);
            if (bottom < this.getY() || top > this.getBottom()) continue;
            Entry entry = (Entry)((Object)this.children().get(index));
            int height = 20;
            boolean isMouseOver = this.isMouseOver(mouseX, mouseY) && mouseX >= this.getX() && mouseX <= this.getX() + this.width && mouseY >= top && mouseY < bottom;
            entry.render(guiGraphics, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTicks);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderContent(GuiGraphics guiGraphics, int index, int top, boolean isMouseOver, float partialTicks) {
        }
    }

    class OptionEntry
    extends Entry {
        private final String name;
        private final Button toggleButton;
        private final Button helpButton;
        private final Option option;

        public OptionEntry(String optionName, Option option) {
            this.name = optionName;
            this.option = option;
            Tooltip toggleTooltip = null;
            if (this.option.isModDefined()) {
                String disablingMods = String.join((CharSequence)", ", this.option.getDefiningMods());
                toggleTooltip = Tooltip.create((Component)Component.translatable((String)("modernfix.option." + (this.option.isEnabled() ? "enabled" : "disabled"))).append((Component)Component.translatable((String)"modernfix.option.mod_override", (Object[])new Object[]{disablingMods})));
            }
            this.toggleButton = new Button.Builder((Component)Component.literal((String)""), arg -> {
                this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                try {
                    ModernFixMixinPlugin.instance.config.save();
                    if (!OptionList.this.mainScreen.madeChanges) {
                        OptionList.this.mainScreen.madeChanges = true;
                    }
                }
                catch (IOException e) {
                    this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                    ModernFix.LOGGER.error("Unable to save config", (Throwable)e);
                }
                OptionList.this.updateOptionEntryStatuses();
            }).tooltip(toggleTooltip).pos(0, 0).size(55, 20).build();
            this.updateStatus();
            this.helpButton = new Button.Builder((Component)Component.literal((String)"?"), arg -> {
                OptionList.this.mainScreen.setLastScrollAmount(OptionList.this.scrollAmount());
                Minecraft.getInstance().setScreen((Screen)new ModernFixOptionInfoScreen(OptionList.this.mainScreen, optionName));
            }).pos(75, 0).size(20, 20).build();
            if (!I18n.exists((String)("modernfix.option." + optionName))) {
                this.helpButton.active = false;
                if (ModernFixPlatformHooks.INSTANCE.isDevEnv() && OPTIONS_MISSING_HELP.add(optionName)) {
                    ModernFix.LOGGER.warn("Missing help for {}", (Object)optionName);
                }
            }
        }

        void updateStatus() {
            boolean isDynamicResources = this.name.equals("mixin.perf.dynamic_resources") || this.name.startsWith("mixin.perf.dynamic_resources.");
            this.toggleButton.active = !this.option.isModDefined() && !this.option.isEffectivelyDisabledByParent() && !isDynamicResources;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            boolean isDynamicResources;
            MutableComponent nameComponent = OptionList.getOptionComponent(this.option);
            if (this.option.isUserDefined()) {
                nameComponent = nameComponent.withStyle(style -> style.withItalic(Boolean.valueOf(true))).append((Component)Component.translatable((String)"modernfix.config.not_default"));
            }
            boolean bl = isDynamicResources = this.name.equals("mixin.perf.dynamic_resources") || this.name.startsWith("mixin.perf.dynamic_resources.");
            if (isDynamicResources) {
                nameComponent = nameComponent.append((Component)Component.literal((String)" [BROKEN]").withStyle(ChatFormatting.RED));
            }
            float textX = left + 20 * this.option.getDepth() + 160 - OptionList.this.maxNameWidth;
            float textY = top + height / 2 - 4;
            guiGraphics.drawString(((OptionList)OptionList.this).minecraft.font, (Component)nameComponent, (int)textX, (int)textY, -1);
            this.toggleButton.setPosition(left + 175, top);
            this.toggleButton.setMessage(this.getOptionMessage(this.option));
            this.toggleButton.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.helpButton.setPosition(left + 175 + 55, top);
            this.helpButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        private Component getOptionMessage(Option option) {
            return option.isEnabled() ? OPTION_ON : OPTION_OFF;
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.toggleButton, (Object)this.helpButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    class CategoryEntry
    extends Entry {
        private final Component name;
        private final int width;

        public CategoryEntry(Component component) {
            this.name = component;
            this.width = ((OptionList)OptionList.this).minecraft.font.width((FormattedText)this.name);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            Font var10000 = ((OptionList)OptionList.this).minecraft.font;
            float x = ((OptionList)OptionList.this).minecraft.screen.width / 2 - this.width / 2;
            int y = top + height - 10;
            guiGraphics.drawString(var10000, this.name, (int)x, y, -1);
        }

        public boolean changeFocus(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

