/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.dynresources;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.resources.model.ModelBakery;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;
import org.embeddedt.modernfix.dynamicresources.DynamicModelProvider;

public class ModelBakeEventHelper {
    private final DynamicModelProvider modelRegistry;
    private final MutableGraph<String> dependencyGraph;

    public ModelBakeEventHelper(DynamicModelProvider modelRegistry) {
        this.modelRegistry = modelRegistry;
        this.dependencyGraph = GraphBuilder.undirected().build();
        ModList.get().forEachModContainer((id, mc) -> {
            this.dependencyGraph.addNode(id);
            for (IModInfo.ModVersion version : mc.getModInfo().getDependencies()) {
                this.dependencyGraph.addNode((Object)version.getModId());
            }
        });
        for (String id2 : this.dependencyGraph.nodes()) {
            Optional mContainer = ModList.get().getModContainerById(id2);
            if (!mContainer.isPresent()) continue;
            for (IModInfo.ModVersion version : ((ModContainer)mContainer.get()).getModInfo().getDependencies()) {
                if (Objects.equals(id2, version.getModId())) continue;
                this.dependencyGraph.putEdge((Object)id2, (Object)version.getModId());
            }
        }
    }

    public ModelBakery.BakingResult createDynamicResult() {
        return new ModelBakery.BakingResult(new ModelBakery.MissingModels(this.modelRegistry.getMissingBakedModel(), this.modelRegistry.getMissingItemModel()), this.modelRegistry.getTopLevelEmulatedRegistry(), this.modelRegistry.getItemModelEmulatedRegistry(), this.modelRegistry.getItemPropertiesEmulatedRegistry());
    }
}

