/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_2940;
import net.minecraft.class_310;
import net.minecraft.class_6416;
import net.minecraft.server.MinecraftServer;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.spark.SparkLaunchProfiler;
import org.embeddedt.modernfix.util.ClassInfoManager;
import org.embeddedt.modernfix.world.IntegratedWatchdog;

public class ModernFixClient {
    public static ModernFixClient INSTANCE;
    public static long worldLoadStartTime;
    private static int numRenderTicks;
    public static float gameStartTimeSeconds;
    public static boolean recipesUpdated;
    public static boolean tagsUpdated;
    public String brandingString = null;
    public static List<ModernFixClientIntegration> CLIENT_INTEGRATIONS;

    public ModernFixClient() {
        INSTANCE = this;
        class_6416.method_37415();
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.branding.F3Screen")) {
            this.brandingString = ModernFix.NAME + " " + ModernFixPlatformHooks.INSTANCE.getVersionString();
        }
        for (String className : ModernFixPlatformHooks.INSTANCE.getCustomModOptions().get((Object)"client_entrypoint")) {
            try {
                CLIENT_INTEGRATIONS.add((ModernFixClientIntegration)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Could not instantiate integration {}", (Object)className, (Object)e);
            }
        }
        if (ModernFixMixinPlugin.instance.isOptionEnabled("perf.dynamic_resources.FireIntegrationHook")) {
            for (ModernFixClientIntegration integration : CLIENT_INTEGRATIONS) {
                integration.onDynamicResourcesStatusChange(true);
            }
        }
    }

    public void resetWorldLoadStateMachine() {
        numRenderTicks = 0;
        worldLoadStartTime = -1L;
        recipesUpdated = false;
        tagsUpdated = false;
    }

    public void onGameLaunchFinish() {
        if (gameStartTimeSeconds >= 0.0f) {
            return;
        }
        gameStartTimeSeconds = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.GameLoad")) {
            ModernFix.LOGGER.warn("Game took " + gameStartTimeSeconds + " seconds to start");
        }
        ModernFixPlatformHooks.INSTANCE.onLaunchComplete();
        ClassInfoManager.clear();
    }

    public void onRecipesUpdated() {
        recipesUpdated = true;
    }

    public void onTagsUpdated() {
        tagsUpdated = true;
    }

    public void onRenderTickEnd() {
        if (recipesUpdated && tagsUpdated && worldLoadStartTime != -1L && class_310.method_1551().field_1724 != null && numRenderTicks++ >= 10) {
            float timeSpentLoading = (float)(System.nanoTime() - worldLoadStartTime) / 1.0E9f;
            if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.WorldLoad")) {
                ModernFix.LOGGER.warn("Time from main menu to in-game was " + timeSpentLoading + " seconds");
                ModernFix.LOGGER.warn("Total time to load game and open world was " + (timeSpentLoading + gameStartTimeSeconds) + " seconds");
            }
            if (ModernFixPlatformHooks.INSTANCE.modPresent("spark") && ModernFixMixinPlugin.instance.isOptionEnabled("feature.spark_profile_world_join.WorldJoin")) {
                SparkLaunchProfiler.stop("world_join");
            }
            this.resetWorldLoadStateMachine();
        }
    }

    private static boolean compareAndSwitchIds(Class<? extends class_1297> eClass, String fieldName, class_2940<?> accessor, int newId) {
        if (accessor.comp_2327 != newId) {
            ModernFix.LOGGER.warn("Corrected ID mismatch on {} field {}. Client had {} but server wants {}.", eClass, (Object)fieldName, (Object)accessor.comp_2327, (Object)newId);
            accessor.comp_2327 = newId;
            return true;
        }
        ModernFix.LOGGER.debug("{} {} ID fine: {}", eClass, (Object)fieldName, (Object)newId);
        return false;
    }

    public void onServerStarted(MinecraftServer server) {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("feature.integrated_server_watchdog.IntegratedWatchdog")) {
            return;
        }
        IntegratedWatchdog watchdog = new IntegratedWatchdog(server);
        watchdog.start();
    }

    static {
        worldLoadStartTime = -1L;
        gameStartTimeSeconds = -1.0f;
        tagsUpdated = false;
        CLIENT_INTEGRATIONS = new CopyOnWriteArrayList<ModernFixClientIntegration>();
    }
}

