/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import java.lang.management.ManagementFactory;
import net.minecraft.SharedConstants;
import net.minecraft.TracingExecutor;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.command.ModernFixCommands;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.resources.ReloadExecutor;
import org.embeddedt.modernfix.util.ClassInfoManager;

public class ModernFix {
    public static final Logger LOGGER = LogManager.getLogger((String)"ModernFix");
    public static final String MODID = "modernfix";
    public static String NAME = "ModernFix";
    public static ModernFix INSTANCE;
    public static boolean runningFirstInjection;
    private static TracingExecutor resourceReloadService;

    public static TracingExecutor resourceReloadExecutor() {
        return resourceReloadService;
    }

    public ModernFix() {
        INSTANCE = this;
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.snapshot_easter_egg.NameChange") && !SharedConstants.getCurrentVersion().isStable()) {
            NAME = "PreemptiveFix";
        }
        ModernFixPlatformHooks.INSTANCE.onServerCommandRegister(ModernFixCommands::register);
    }

    public void onServerStarted() {
        if (ModernFixPlatformHooks.INSTANCE.isDedicatedServer()) {
            float gameStartTime = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.measure_time.ServerLoad")) {
                LOGGER.warn("Dedicated server took " + gameStartTime + " seconds to load");
            }
            ModernFixPlatformHooks.INSTANCE.onLaunchComplete();
        }
        ClassInfoManager.clear();
    }

    public void onServerDead(MinecraftServer server) {
        try {
            for (ServerLevel level : server.getAllLevels()) {
                ChunkMap chunkMap = level.getChunkSource().chunkMap;
                if (chunkMap.updatingChunkMap != null) {
                    chunkMap.updatingChunkMap.clear();
                }
                if (chunkMap.visibleChunkMap != null) {
                    chunkMap.visibleChunkMap.clear();
                }
                if (chunkMap.pendingUnloads == null) continue;
                chunkMap.pendingUnloads.clear();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Couldn't clear chunk data", (Throwable)e);
        }
    }

    static {
        runningFirstInjection = false;
        resourceReloadService = null;
        resourceReloadService = ModernFixMixinPlugin.instance.isOptionEnabled("perf.dedicated_reload_executor.ReloadExecutor") ? ReloadExecutor.createCustomResourceReloadExecutor() : Util.backgroundExecutor();
    }
}

