/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.sss.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public static float SATURATION = 1.0f;
    public static float SHADE_BLEND = 0.75f;
    public static boolean SATURATION_THEN_FOG = false;
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public static final OptionStorage<Config> STOREAGE = new OptionStorage<Config>(){

        public Config getData() {
            return null;
        }

        public void save() {
        }
    };

    private static void loadOrCreate() {
        Path path = Config.getConfigPath();
        if (Files.exists(path, new LinkOption[0])) {
            try (FileReader reader = new FileReader(path.toFile());){
                Storage conf = (Storage)GSON.fromJson((Reader)reader, Storage.class);
                if (conf != null) {
                    SATURATION = conf.saturation;
                    SHADE_BLEND = conf.shade;
                    SATURATION_THEN_FOG = conf.saturation_then_fog;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Config.save();
    }

    private static void save() {
        Storage s = new Storage();
        s.saturation = SATURATION;
        s.shade = SHADE_BLEND;
        s.saturation_then_fog = SATURATION_THEN_FOG;
        try {
            Files.writeString(Config.getConfigPath(), (CharSequence)GSON.toJson((Object)s), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("sss-config.json");
    }

    static {
        Config.loadOrCreate();
    }

    private static final class Storage {
        public float saturation;
        public float shade;
        public boolean saturation_then_fog;

        private Storage() {
        }
    }
}

