/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.bukkit;

import dev.triumphteam.cmd.bukkit.BukkitCommandProcessor;
import dev.triumphteam.cmd.bukkit.BukkitSubCommand;
import dev.triumphteam.cmd.bukkit.CommandPermission;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.bukkit.message.NoPermissionMessageContext;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.message.MessageRegistry;
import dev.triumphteam.cmd.core.message.context.DefaultMessageContext;
import dev.triumphteam.cmd.core.sender.SenderMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitCommand<S>
extends Command
implements dev.triumphteam.cmd.core.Command<S, BukkitSubCommand<S>> {
    private final MessageRegistry<S> messageRegistry;
    private final SenderMapper<CommandSender, S> senderMapper;
    private final Map<String, BukkitSubCommand<S>> subCommands = new HashMap<String, BukkitSubCommand<S>>();
    private final Map<String, BukkitSubCommand<S>> subCommandAliases = new HashMap<String, BukkitSubCommand<S>>();

    public BukkitCommand(@NotNull String name, @NotNull BukkitCommandProcessor<S> processor) {
        super(name);
        this.description = processor.getDescription();
        this.messageRegistry = processor.getRegistryContainer().getMessageRegistry();
        this.senderMapper = processor.getSenderMapper();
    }

    @Override
    public void addSubCommand(@NotNull String name, @NotNull BukkitSubCommand<S> subCommand) {
        this.subCommands.putIfAbsent(name, subCommand);
    }

    @Override
    public void addSubCommandAlias(@NotNull String alias, @NotNull BukkitSubCommand<S> subCommand) {
        this.subCommandAliases.putIfAbsent(alias, subCommand);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull @NotNull String @NotNull [] args) {
        S mappedSender;
        BukkitSubCommand<S> subCommand = this.getDefaultSubCommand();
        String subCommandName = "";
        if (args.length > 0) {
            subCommandName = args[0].toLowerCase();
        }
        if (subCommand == null || this.subCommandExists(subCommandName)) {
            subCommand = this.getSubCommand(subCommandName);
        }
        if ((mappedSender = this.senderMapper.map(sender)) == null) {
            throw new CommandExecutionException("Invalid sender. Sender mapper returned null");
        }
        if (subCommand == null || args.length > 0 && subCommand.isDefault() && !subCommand.hasArguments()) {
            this.messageRegistry.sendMessage(MessageKey.UNKNOWN_COMMAND, mappedSender, new DefaultMessageContext(this.getName(), subCommandName));
            return true;
        }
        CommandPermission permission = subCommand.getPermission();
        if (!CommandPermission.hasPermission(sender, permission)) {
            this.messageRegistry.sendMessage(BukkitMessageKey.NO_PERMISSION, mappedSender, new NoPermissionMessageContext(this.getName(), subCommand.getName(), permission));
            return true;
        }
        List<String> commandArgs = Arrays.asList(!subCommand.isDefault() ? Arrays.copyOfRange(args, 1, args.length) : args);
        subCommand.execute(mappedSender, commandArgs);
        return true;
    }

    @NotNull
    public @NotNull List<@NotNull String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        BukkitSubCommand<S> subCommand = this.getDefaultSubCommand();
        String arg = args[0].toLowerCase();
        if (!(args.length != 1 || subCommand != null && subCommand.hasArguments())) {
            return this.subCommands.entrySet().stream().filter(it -> !((BukkitSubCommand)it.getValue()).isDefault()).filter(it -> ((String)it.getKey()).startsWith(arg)).filter(it -> {
                CommandPermission permission = ((BukkitSubCommand)it.getValue()).getPermission();
                return CommandPermission.hasPermission(sender, permission);
            }).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        if (this.subCommandExists(arg)) {
            subCommand = this.getSubCommand(arg);
        }
        if (subCommand == null) {
            return Collections.emptyList();
        }
        CommandPermission permission = subCommand.getPermission();
        if (!CommandPermission.hasPermission(sender, permission)) {
            return Collections.emptyList();
        }
        S mappedSender = this.senderMapper.map(sender);
        if (mappedSender == null) {
            return Collections.emptyList();
        }
        List<String> commandArgs = Arrays.asList(args);
        return subCommand.getSuggestions(mappedSender, !subCommand.isDefault() ? commandArgs.subList(1, commandArgs.size()) : commandArgs);
    }

    @Nullable
    private BukkitSubCommand<S> getDefaultSubCommand() {
        return this.subCommands.get("TH_DEFAULT");
    }

    @Nullable
    private BukkitSubCommand<S> getSubCommand(@NotNull String key) {
        BukkitSubCommand<S> subCommand = this.subCommands.get(key);
        if (subCommand != null) {
            return subCommand;
        }
        return this.subCommandAliases.get(key);
    }

    private boolean subCommandExists(@NotNull String key) {
        return this.subCommands.containsKey(key) || this.subCommandAliases.containsKey(key);
    }
}

