/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.named;

import dev.triumphteam.cmd.core.argument.named.ArgumentBuilder;
import dev.triumphteam.cmd.core.argument.named.ListArgumentBuilder;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Argument {
    @NotNull
    public static ArgumentBuilder forString() {
        return new ArgumentBuilder(String.class);
    }

    @NotNull
    public static ArgumentBuilder forInt() {
        return new ArgumentBuilder(Integer.TYPE);
    }

    @NotNull
    public static ArgumentBuilder forFloat() {
        return new ArgumentBuilder(Float.TYPE);
    }

    @NotNull
    public static ArgumentBuilder forDouble() {
        return new ArgumentBuilder(Double.TYPE);
    }

    @NotNull
    public static ArgumentBuilder forBoolean() {
        return new ArgumentBuilder(Boolean.TYPE);
    }

    @NotNull
    public static ArgumentBuilder forType(@NotNull Class<?> type) {
        return new ArgumentBuilder(type);
    }

    @NotNull
    public static ListArgumentBuilder listOf(@NotNull Class<?> type) {
        return new ListArgumentBuilder(List.class, type);
    }

    @NotNull
    public static ListArgumentBuilder setOf(@NotNull Class<?> type) {
        return new ListArgumentBuilder(Set.class, type);
    }

    @NotNull
    public Class<?> getType();

    @NotNull
    public String getName();

    @NotNull
    public String getDescription();

    @Nullable
    public SuggestionKey getSuggestion();
}

