/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.suggestion.Suggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionContext;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleSuggestion<S>
implements Suggestion<S> {
    private final SuggestionResolver<S> resolver;

    public SimpleSuggestion(@NotNull SuggestionResolver<S> resolver) {
        this.resolver = resolver;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull SuggestionContext context) {
        return this.resolver.resolve(sender, context).stream().filter(it -> it.toLowerCase().startsWith(current.toLowerCase())).collect(Collectors.toList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSuggestion that = (SimpleSuggestion)o;
        return this.resolver.equals(that.resolver);
    }

    public int hashCode() {
        return Objects.hash(this.resolver);
    }

    @NotNull
    public String toString() {
        return "SimpleSuggestion{resolver=" + this.resolver + '}';
    }
}

