/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun;

import hu.kxtsoo.fungun.bstats.bukkit.Metrics;
import hu.kxtsoo.fungun.database.DatabaseManager;
import hu.kxtsoo.fungun.events.FallingBlockListener;
import hu.kxtsoo.fungun.events.InventoryClickListener;
import hu.kxtsoo.fungun.events.PlayerDropItemListener;
import hu.kxtsoo.fungun.events.PlayerInteractListener;
import hu.kxtsoo.fungun.events.PlayerJoinListener;
import hu.kxtsoo.fungun.events.PlayerSwapHandItemsListener;
import hu.kxtsoo.fungun.events.PlayerTeleportListener;
import hu.kxtsoo.fungun.events.ProjectileHitListener;
import hu.kxtsoo.fungun.events.WorldChangeListener;
import hu.kxtsoo.fungun.hooks.HookManager;
import hu.kxtsoo.fungun.manager.CommandManager;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.manager.SchedulerManager;
import hu.kxtsoo.fungun.util.ConfigUtil;
import hu.kxtsoo.fungun.util.UpdateChecker;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class FunGun
extends JavaPlugin {
    private static FunGun instance;
    private ConfigUtil configUtil;
    private CooldownManager cooldownManager;

    public void onEnable() {
        instance = this;
        int pluginId = 23693;
        new Metrics(this, pluginId);
        ConfigUtil.configUtil = this.configUtil = new ConfigUtil(this);
        SchedulerManager.run(() -> new HookManager().updateHooks());
        try {
            DatabaseManager.initialize(this.configUtil, this);
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        CommandManager commandManager = new CommandManager(this);
        commandManager.registerSuggestions();
        commandManager.registerCommands();
        this.cooldownManager = new CooldownManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerTeleportListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldChangeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(this, this.cooldownManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ProjectileHitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDropItemListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerSwapHandItemsListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FallingBlockListener(), (Plugin)this);
        String blue = "\u001b[38;2;53;151;255m";
        String reset = "\u001b[0m";
        String yellow = "\u001b[33m";
        String software = this.getServer().getName();
        String version = this.getServer().getVersion();
        this.getLogger().info(" ");
        this.getLogger().info(blue + "    _____ _   _ _   _  ____ _   _ _   _ " + reset);
        this.getLogger().info(blue + "   |  ___| | | | \\ | |/ ___| | | | \\ | |" + reset);
        this.getLogger().info(blue + "   | |_  | | | |  \\| | |  _| | | |  \\| |" + reset);
        this.getLogger().info(blue + "   |  _| | |_| | |\\  | |_| | |_| | |\\  |" + reset);
        this.getLogger().info(blue + "   |_|    \\___/|_| \\_|\\____|\\___/|_| \\_|" + reset);
        this.getLogger().info(" ");
        this.getLogger().info(blue + "   The plugin successfully started." + reset);
        this.getLogger().info(blue + "   mc-FunGun " + software + " " + version + reset);
        this.getLogger().info(yellow + "   Discord @ dc.mongenscave.com" + reset);
        this.getLogger().info(" ");
        this.getLogger().info("\u001b[33m   [Database] Selected database type: " + DatabaseManager.getDatabaseType() + "\u001b[0m");
        if (this.getConfig().getBoolean("update-checker.enabled", true)) {
            new UpdateChecker(this, this.configUtil, 5557);
        }
    }

    public void onDisable() {
        try {
            DatabaseManager.close();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "Failed to close database", e);
        }
    }

    public static FunGun getInstance() {
        return instance;
    }

    public ConfigUtil getConfigUtil() {
        return this.configUtil;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }
}

