/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.abilities;

import dev.dejvokep.boostedyaml.YamlDocument;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.manager.SchedulerManager;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class BatSwarmAbility
extends AbilityHandler {
    private final JavaPlugin plugin;
    private final int cooldown;
    private final int swarmSize;
    private final int flightDuration;
    private final double speed;
    private final Particle particle;
    private final Sound startSound;
    private final Sound endSound;
    private final Random random = new Random();

    public BatSwarmAbility(CooldownManager cooldownHandler, JavaPlugin plugin) {
        this.plugin = plugin;
        YamlDocument config = ConfigUtil.configUtil.getAbilitiesMap().get("BATSWARM");
        this.setName("BatSwarm");
        this.cooldown = config.getInt("ability.options.cooldown", Integer.valueOf(20));
        this.setCooldown(this.cooldown);
        this.setCooldownManager(cooldownHandler);
        this.swarmSize = config.getInt("ability.options.swarm-size", Integer.valueOf(10));
        this.flightDuration = config.getInt("ability.options.flight-duration-seconds", Integer.valueOf(5)) * 20;
        this.speed = config.getDouble("ability.options.speed", Double.valueOf(0.4));
        this.particle = Particle.valueOf((String)config.getString("ability.options.particle", "SMOKE_LARGE"));
        this.startSound = Sound.valueOf((String)config.getString("ability.options.start-sound", "ENTITY_BAT_AMBIENT"));
        this.endSound = Sound.valueOf((String)config.getString("ability.options.end-sound", "ENTITY_BAT_TAKEOFF"));
    }

    @Override
    public void useAbility(final Player player) {
        SchedulerManager.Task[] task;
        if (this.getCooldownManager().hasAbilityCooldown(player)) {
            int remainingCooldown = this.getCooldownManager().getRemainingAbilityCooldown(player);
            if (remainingCooldown > 0 && (double)remainingCooldown == Math.floor(remainingCooldown)) {
                String actionBarMessage;
                if (!ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").isEmpty()) {
                    player.sendMessage(ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").replace("%cooldown%", String.valueOf(remainingCooldown)));
                }
                if ((actionBarMessage = ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown-actionbar")) != null && !actionBarMessage.isEmpty()) {
                    actionBarMessage = actionBarMessage.replace("%cooldown%", String.valueOf(remainingCooldown));
                    player.sendActionBar(actionBarMessage);
                }
            }
            return;
        }
        this.getCooldownManager().startAbilityCooldown(player, this.getCooldown());
        final ArrayList<Bat> bats = new ArrayList<Bat>();
        Location spawnLocation = player.getLocation().add(player.getLocation().getDirection().multiply(2)).add(0.0, 1.0, 0.0);
        final Vector direction = player.getLocation().getDirection().normalize().multiply(this.speed);
        for (int i = 0; i < this.swarmSize; ++i) {
            Location batLocation = spawnLocation.clone().add((this.random.nextDouble() - 0.5) * 2.0, this.random.nextDouble() * 1.5, (this.random.nextDouble() - 0.5) * 2.0);
            Bat bat = (Bat)player.getWorld().spawn(batLocation, Bat.class);
            bat.setSilent(true);
            bats.add(bat);
        }
        task = new SchedulerManager.Task[]{SchedulerManager.runTimer(new Runnable(){
            int ticks = 0;

            @Override
            public void run() {
                if (this.ticks >= BatSwarmAbility.this.flightDuration) {
                    bats.forEach(Entity::remove);
                    player.getWorld().playSound(player.getLocation(), BatSwarmAbility.this.endSound, 1.0f, 0.8f);
                    task[0].cancel();
                    return;
                }
                for (Bat bat : bats) {
                    bat.setVelocity(direction);
                    if (this.ticks % 5 != 0) continue;
                    bat.getWorld().spawnParticle(BatSwarmAbility.this.particle, bat.getLocation(), 1, 0.2, 0.2, 0.2, 0.05);
                }
                ++this.ticks;
            }
        }, 0L, 1L)};
        player.getWorld().playSound(player.getLocation(), this.startSound, 1.0f, 0.8f);
    }
}

