/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.abilities;

import dev.dejvokep.boostedyaml.YamlDocument;
import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.manager.SchedulerManager;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class ExplosionAbility
extends AbilityHandler {
    private final JavaPlugin plugin;
    private final int maxBlocks;
    private final int maxHeight;
    private final int explosionRadius;
    private final int removeDelayTicks;

    public ExplosionAbility(CooldownManager cooldownHandler, JavaPlugin plugin) {
        YamlDocument explosionConfig = ConfigUtil.configUtil.getAbilitiesMap().get("EXPLOSION");
        String name = "Explosion";
        int cooldown = explosionConfig != null ? explosionConfig.getInt("ability.options.cooldown", Integer.valueOf(15)) : 15;
        this.setName(name);
        this.setCooldown(cooldown);
        this.setCooldownManager(cooldownHandler);
        this.plugin = plugin;
        this.maxBlocks = explosionConfig.getInt("ability.options.max-blocks", Integer.valueOf(10));
        this.maxHeight = explosionConfig.getInt("ability.options.max-height", Integer.valueOf(3));
        this.explosionRadius = explosionConfig.getInt("ability.options.explosion-radius", Integer.valueOf(2));
        this.removeDelayTicks = explosionConfig.getInt("ability.options.remove-delay-ticks", Integer.valueOf(35));
    }

    @Override
    public void useAbility(Player player) {
        Particle trailParticle;
        YamlDocument explosionConfig = ConfigUtil.configUtil.getAbilitiesMap().get("EXPLOSION");
        if (explosionConfig == null || !explosionConfig.getBoolean("ability.enabled", Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        String permission = explosionConfig.getString("ability.options.permission", "fungun.ability.explosion");
        if (!player.hasPermission(permission)) {
            player.sendMessage(ConfigUtil.configUtil.getMessage("messages.fungun.no-ability-permission"));
            return;
        }
        if (this.getCooldownManager().hasAbilityCooldown(player)) {
            int remainingCooldown = this.getCooldownManager().getRemainingAbilityCooldown(player);
            if (remainingCooldown > 0 && (double)remainingCooldown == Math.floor(remainingCooldown)) {
                String actionBarMessage;
                if (!ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").isEmpty()) {
                    player.sendMessage(ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").replace("%cooldown%", String.valueOf(remainingCooldown)));
                }
                if ((actionBarMessage = ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown-actionbar")) != null && !actionBarMessage.isEmpty()) {
                    actionBarMessage = actionBarMessage.replace("%cooldown%", String.valueOf(remainingCooldown));
                    player.sendActionBar(actionBarMessage);
                }
            }
            return;
        }
        this.getCooldownManager().startAbilityCooldown(player, this.getCooldown());
        final int maxSteps = explosionConfig.getInt("ability.options.steps", Integer.valueOf(4));
        long stepDelayTicks = explosionConfig.getLong("ability.options.step-delay-ticks", Long.valueOf(5L));
        String trailParticleName = explosionConfig.getString("ability.options.trail-particle", "FLAME");
        final int particleCount = explosionConfig.getInt("ability.options.particle-count", Integer.valueOf(5));
        try {
            trailParticle = Particle.valueOf((String)trailParticleName);
        }
        catch (IllegalArgumentException e) {
            trailParticle = Particle.FLAME;
            FunGun.getInstance().getLogger().warning("Invalid particle type in config for Explosion ability. Defaulting to FLAME.");
        }
        final Location startLocation = player.getLocation();
        final Vector direction = player.getLocation().getDirection().normalize().setY(0).multiply(1.0);
        final SchedulerManager.Task[] task = new SchedulerManager.Task[1];
        final Particle finalTrailParticle = trailParticle;
        task[0] = SchedulerManager.runTimer(new Runnable(){
            int steps = 0;
            Location currentLocation = startLocation.clone();

            @Override
            public void run() {
                if (this.steps >= maxSteps) {
                    ExplosionAbility.this.createExplosionEffect(this.currentLocation);
                    task[0].cancel();
                    return;
                }
                Location groundLocation = this.currentLocation.clone();
                while (groundLocation.getBlock().getType() == Material.AIR && groundLocation.getY() > 0.0) {
                    groundLocation.subtract(0.0, 1.0, 0.0);
                }
                this.currentLocation = groundLocation.add(direction);
                this.currentLocation.getWorld().spawnParticle(finalTrailParticle, this.currentLocation, particleCount, 0.1, 0.0, 0.1, 0.05);
                ++this.steps;
            }
        }, 0L, stepDelayTicks);
    }

    private void createExplosionEffect(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        this.playSounds(location);
        this.spawnParticles(location);
        this.simulateBlockExplosion(location);
        this.spawnFallingBlockEffect(location);
    }

    private void playSounds(Location location) {
        List sounds = ConfigUtil.configUtil.getAbilitiesMap().get("EXPLOSION").getStringList("sounds");
        for (String soundConfig : sounds) {
            String[] soundParams = soundConfig.split(",");
            try {
                Sound sound = Sound.valueOf((String)soundParams[0]);
                float volume = Float.parseFloat(soundParams[1]);
                float pitch = Float.parseFloat(soundParams[2]);
                location.getWorld().playSound(location, sound, volume, pitch);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void spawnParticles(Location location) {
        List particles = ConfigUtil.configUtil.getAbilitiesMap().get("EXPLOSION").getStringList("particles");
        for (String particleConfigEntry : particles) {
            String[] particleParams = particleConfigEntry.split(",");
            try {
                Particle particle = Particle.valueOf((String)particleParams[0]);
                int count = Integer.parseInt(particleParams[1]);
                double offsetX = Double.parseDouble(particleParams[2]);
                double offsetY = Double.parseDouble(particleParams[3]);
                double offsetZ = Double.parseDouble(particleParams[4]);
                double extra = Double.parseDouble(particleParams[5]);
                location.getWorld().spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, extra);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void simulateBlockExplosion(Location location) {
        Random random = new Random();
        World world = location.getWorld();
        for (int i = 0; i < this.maxBlocks; ++i) {
            Location particleLocation = location.clone().add(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5);
            Material blockType = Material.STONE;
            world.spawnParticle(Particle.BLOCK_CRACK, particleLocation, 15, 0.3, 0.3, 0.3, (Object)blockType.createBlockData());
        }
    }

    private void spawnFallingBlockEffect(Location location) {
        int blockCount = 0;
        for (int x = -this.explosionRadius; x <= this.explosionRadius; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -this.explosionRadius; z <= this.explosionRadius; ++z) {
                    if (blockCount >= this.maxBlocks) {
                        return;
                    }
                    Location blockLocation = location.clone().add((double)x, (double)y, (double)z);
                    Block block = blockLocation.getBlock();
                    if (block.getType() == Material.AIR) continue;
                    BlockData blockData = block.getBlockData();
                    FallingBlock fallingBlock = location.getWorld().spawnFallingBlock(blockLocation, blockData);
                    double upwardVelocity = 0.3 + Math.random() * ((double)this.maxHeight / 2.0);
                    Vector velocity = new Vector((Math.random() - 0.5) * 0.5, upwardVelocity, (Math.random() - 0.5) * 0.5);
                    fallingBlock.setVelocity(velocity);
                    fallingBlock.setDropItem(false);
                    fallingBlock.setHurtEntities(false);
                    fallingBlock.setPersistent(false);
                    fallingBlock.setGravity(true);
                    fallingBlock.setMetadata("fungun_visual", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
                    ++blockCount;
                }
            }
        }
    }
}

