/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.abilities;

import dev.dejvokep.boostedyaml.YamlDocument;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.manager.SchedulerManager;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class MeteorAbility
extends AbilityHandler {
    private final JavaPlugin plugin;
    private final int cooldown;
    private final double meteorSpeed;
    private final Material meteorMaterial;
    private final int particleCount;
    private final List<String> impactParticles;
    private final List<String> impactSounds;

    public MeteorAbility(CooldownManager cooldownHandler, JavaPlugin plugin) {
        YamlDocument meteorConfig = ConfigUtil.configUtil.getAbilitiesMap().get("METEOR");
        String name = "Meteor";
        this.cooldown = meteorConfig != null ? meteorConfig.getInt("ability.options.cooldown", Integer.valueOf(20)) : 20;
        this.setName(name);
        this.setCooldown(this.cooldown);
        this.setCooldownManager(cooldownHandler);
        this.plugin = plugin;
        this.meteorSpeed = meteorConfig.getDouble("ability.options.meteor-speed", Double.valueOf(0.5));
        String materialName = meteorConfig.getString("ability.options.meteor-material", "MAGMA_BLOCK");
        this.meteorMaterial = Material.matchMaterial((String)materialName) != null ? Material.matchMaterial((String)materialName) : Material.MAGMA_BLOCK;
        this.particleCount = meteorConfig.getInt("ability.options.particle-count", Integer.valueOf(10));
        this.impactParticles = meteorConfig.getStringList("particles");
        this.impactSounds = meteorConfig.getStringList("sounds");
    }

    @Override
    public void useAbility(Player player) {
        SchedulerManager.Task[] task;
        if (this.getCooldownManager().hasAbilityCooldown(player)) {
            int remainingCooldown = this.getCooldownManager().getRemainingAbilityCooldown(player);
            if (remainingCooldown > 0 && (double)remainingCooldown == Math.floor(remainingCooldown)) {
                String actionBarMessage;
                if (!ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").isEmpty()) {
                    player.sendMessage(ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").replace("%cooldown%", String.valueOf(remainingCooldown)));
                }
                if ((actionBarMessage = ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown-actionbar")) != null && !actionBarMessage.isEmpty()) {
                    actionBarMessage = actionBarMessage.replace("%cooldown%", String.valueOf(remainingCooldown));
                    player.sendActionBar(actionBarMessage);
                }
            }
            return;
        }
        this.getCooldownManager().startAbilityCooldown(player, this.getCooldown());
        Block targetBlock = player.getTargetBlockExact(50);
        if (targetBlock == null) {
            return;
        }
        Location targetLocation = targetBlock.getLocation();
        Location startLocation = targetLocation.clone().add(10.0, 15.0, 10.0);
        final Vector direction = targetLocation.toVector().subtract(startLocation.toVector()).normalize().multiply(this.meteorSpeed);
        direction.setY(-this.meteorSpeed);
        final FallingBlock meteor = startLocation.getWorld().spawnFallingBlock(startLocation, this.meteorMaterial.createBlockData());
        meteor.setDropItem(false);
        meteor.setHurtEntities(false);
        task = new SchedulerManager.Task[]{SchedulerManager.runTimer(new Runnable(){

            @Override
            public void run() {
                if (meteor.isDead() || meteor.isOnGround()) {
                    MeteorAbility.this.createExplosionEffect(meteor.getLocation());
                    meteor.remove();
                    task[0].cancel();
                    return;
                }
                meteor.setVelocity(direction);
                meteor.getWorld().spawnParticle(Particle.FLAME, meteor.getLocation(), MeteorAbility.this.particleCount, 0.2, 0.2, 0.2, 0.05);
            }
        }, 0L, 2L)};
    }

    private void createExplosionEffect(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        for (String soundConfig : this.impactSounds) {
            String[] soundParams = soundConfig.split(",");
            try {
                Sound sound = Sound.valueOf((String)soundParams[0]);
                float volume = Float.parseFloat(soundParams[1]);
                float pitch = Float.parseFloat(soundParams[2]);
                world.playSound(location, sound, volume, pitch);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String particleConfig : this.impactParticles) {
            String[] particleParams = particleConfig.split(",");
            try {
                Particle particle = Particle.valueOf((String)particleParams[0]);
                int count = Integer.parseInt(particleParams[1]);
                double offsetX = Double.parseDouble(particleParams[2]);
                double offsetY = Double.parseDouble(particleParams[3]);
                double offsetZ = Double.parseDouble(particleParams[4]);
                double extra = Double.parseDouble(particleParams[5]);
                world.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, extra);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

