/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.abilities;

import dev.dejvokep.boostedyaml.YamlDocument;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.manager.SchedulerManager;
import hu.kxtsoo.fungun.util.ConfigUtil;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class MountFlightAbility
extends AbilityHandler {
    private final JavaPlugin plugin;
    private final int cooldown;
    private final int flightDuration;
    private final double speed;
    private final EntityType mountType;
    private final Particle particle;
    private final int particleCount;
    private final double particleOffset;
    private final double particleExtra;

    public MountFlightAbility(CooldownManager cooldownHandler, JavaPlugin plugin) {
        this.plugin = plugin;
        YamlDocument config = ConfigUtil.configUtil.getAbilitiesMap().get("MOUNTFLIGHT");
        this.setName("MountFlight");
        this.cooldown = config.getInt("ability.options.cooldown", Integer.valueOf(30));
        this.setCooldown(this.cooldown);
        this.setCooldownManager(cooldownHandler);
        this.flightDuration = config.getInt("ability.options.flight-duration-seconds", Integer.valueOf(5)) * 20;
        this.speed = config.getDouble("ability.options.speed", Double.valueOf(0.6));
        String entityType = config.getString("ability.options.mount-type", "BAT");
        this.mountType = EntityType.valueOf((String)entityType.toUpperCase());
        this.particle = Particle.valueOf((String)config.getString("ability.options.particle", "CLOUD"));
        this.particleCount = config.getInt("ability.options.particle-count", Integer.valueOf(5));
        this.particleOffset = config.getDouble("ability.options.particle-offset", Double.valueOf(0.2));
        this.particleExtra = config.getDouble("ability.options.particle-extra", Double.valueOf(0.02));
    }

    @Override
    public void useAbility(final Player player) {
        SchedulerManager.Task[] task;
        if (this.getCooldownManager().hasAbilityCooldown(player)) {
            int remainingCooldown = this.getCooldownManager().getRemainingAbilityCooldown(player);
            if (remainingCooldown > 0 && (double)remainingCooldown == Math.floor(remainingCooldown)) {
                String actionBarMessage;
                if (!ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").isEmpty()) {
                    player.sendMessage(ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown").replace("%cooldown%", String.valueOf(remainingCooldown)));
                }
                if ((actionBarMessage = ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown-actionbar")) != null && !actionBarMessage.isEmpty()) {
                    actionBarMessage = actionBarMessage.replace("%cooldown%", String.valueOf(remainingCooldown));
                    player.sendActionBar(actionBarMessage);
                }
            }
            return;
        }
        this.getCooldownManager().startAbilityCooldown(player, this.getCooldown());
        Location spawnLocation = player.getLocation();
        final LivingEntity mount = (LivingEntity)player.getWorld().spawnEntity(spawnLocation, this.mountType);
        mount.setInvulnerable(true);
        mount.setSilent(true);
        mount.setGravity(false);
        mount.addPassenger((Entity)player);
        task = new SchedulerManager.Task[]{SchedulerManager.runTimer(new Runnable(){
            int ticks = 0;

            @Override
            public void run() {
                if (this.ticks >= MountFlightAbility.this.flightDuration) {
                    mount.removePassenger((Entity)player);
                    mount.remove();
                    task[0].cancel();
                    return;
                }
                Vector direction = player.getLocation().getDirection().normalize().multiply(MountFlightAbility.this.speed);
                mount.setVelocity(direction);
                mount.getWorld().spawnParticle(MountFlightAbility.this.particle, mount.getLocation(), MountFlightAbility.this.particleCount, MountFlightAbility.this.particleOffset, MountFlightAbility.this.particleOffset, MountFlightAbility.this.particleOffset, MountFlightAbility.this.particleExtra);
                ++this.ticks;
            }
        }, 0L, 1L)};
    }
}

