/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.database.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import hu.kxtsoo.fungun.database.DatabaseInterface;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.plugin.java.JavaPlugin;

public class MySQL
implements DatabaseInterface {
    private final ConfigUtil configUtil;
    private final JavaPlugin plugin;
    private HikariDataSource dataSource;

    public MySQL(ConfigUtil configUtil, JavaPlugin plugin) {
        this.configUtil = configUtil;
        this.plugin = plugin;
    }

    @Override
    public void initialize() throws SQLException {
        HikariConfig hikariConfig = new HikariConfig();
        String host = this.configUtil.getConfig().getString("storage.host", "localhost");
        String port = this.configUtil.getConfig().getString("storage.port", "3306");
        String database = this.configUtil.getConfig().getString("storage.name", "database_name");
        String username = this.configUtil.getConfig().getString("storage.username", "root");
        String password = this.configUtil.getConfig().getString("storage.password", "");
        String jdbcUrl = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false";
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.setMaximumPoolSize(this.configUtil.getConfig().getInt("storage.pool.maximumPoolSize", Integer.valueOf(10)).intValue());
        hikariConfig.setMinimumIdle(this.configUtil.getConfig().getInt("storage.pool.minimumIdle", Integer.valueOf(5)).intValue());
        hikariConfig.setConnectionTimeout((long)this.configUtil.getConfig().getInt("storage.pool.connectionTimeout", Integer.valueOf(30000)).intValue());
        hikariConfig.setMaxLifetime((long)this.configUtil.getConfig().getInt("storage.pool.maxLifetime", Integer.valueOf(1800000)).intValue());
        hikariConfig.setIdleTimeout((long)this.configUtil.getConfig().getInt("storage.pool.idleTimeout", Integer.valueOf(600000)).intValue());
        this.dataSource = new HikariDataSource(hikariConfig);
        this.createTables();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void createTables() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS fungun_users (id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36) NOT NULL, selected_effect VARCHAR(255), selected_ability VARCHAR(255), UNIQUE (uuid));");
        }
    }

    @Override
    public void saveSelectedEffect(String uuid, String effect) throws SQLException {
        String query = "INSERT INTO fungun_users (uuid, selected_effect) VALUES (?, ?) ON DUPLICATE KEY UPDATE selected_effect = VALUES(selected_effect)";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setString(1, uuid);
            ps.setString(2, effect);
            ps.executeUpdate();
        }
    }

    @Override
    public String getSelectedEffect(String uuid) throws SQLException {
        String query = "SELECT selected_effect FROM fungun_users WHERE uuid = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("selected_effect");
                return string;
            }
        }
        return null;
    }

    @Override
    public boolean isEffectSelected(String uuid, String effect) throws SQLException {
        String query = "SELECT 1 FROM fungun_users WHERE uuid = ? AND selected_effect = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    ps.setString(1, uuid);
                    ps.setString(2, effect);
                    ResultSet rs = ps.executeQuery();
                    bl = rs.next();
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    @Override
    public void saveSelectedAbility(String uuid, String ability) throws SQLException {
        String query = "INSERT INTO fungun_users (uuid, selected_ability) VALUES (?, ?) ON DUPLICATE KEY UPDATE selected_ability = VALUES(selected_ability)";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setString(1, uuid);
            ps.setString(2, ability);
            ps.executeUpdate();
        }
    }

    @Override
    public String getSelectedAbility(String uuid) throws SQLException {
        String query = "SELECT selected_ability FROM fungun_users WHERE uuid = ?";
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("selected_ability");
                return string;
            }
        }
        return null;
    }

    @Override
    public boolean isAbilitySelected(String uuid, String ability) throws SQLException {
        String query = "SELECT 1 FROM fungun_users WHERE uuid = ? AND selected_ability = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    ps.setString(1, uuid);
                    ps.setString(2, ability);
                    ResultSet rs = ps.executeQuery();
                    bl = rs.next();
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }
}

