/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.events;

import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.abilities.DashAbility;
import hu.kxtsoo.fungun.database.DatabaseManager;
import hu.kxtsoo.fungun.guis.AbilitiesMenu;
import hu.kxtsoo.fungun.guis.EffectsMenu;
import hu.kxtsoo.fungun.manager.CooldownManager;
import hu.kxtsoo.fungun.model.FunGunItem;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerInteractListener
implements Listener {
    private final JavaPlugin plugin;
    private final CooldownManager cooldownHandler;
    private final Map<String, AbilityHandler> abilities = new HashMap<String, AbilityHandler>();

    public PlayerInteractListener(JavaPlugin plugin, CooldownManager cooldownHandler) {
        this.plugin = plugin;
        this.cooldownHandler = cooldownHandler;
        this.abilities.put("DASH", new DashAbility(cooldownHandler));
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) throws SQLException {
        String defaultAbility;
        String abilityStyle;
        boolean abilitiesEnabled;
        ItemStack itemInHand;
        Player player;
        block21: {
            block23: {
                block22: {
                    player = event.getPlayer();
                    itemInHand = player.getInventory().getItemInMainHand();
                    abilitiesEnabled = FunGun.getInstance().getConfigUtil().getConfig().getBoolean("fungun.options.abilities.enabled", Boolean.valueOf(true));
                    abilityStyle = FunGun.getInstance().getConfigUtil().getConfig().getString("fungun.options.abilities.ability", "switchable");
                    defaultAbility = FunGun.getInstance().getConfigUtil().getConfig().getString("fungun.options.abilities.default-ability", "none");
                    if (!FunGunItem.isFunGunItem(itemInHand, FunGun.getInstance().getConfigUtil()) || !event.getAction().toString().contains("RIGHT")) break block21;
                    String styleOption = FunGun.getInstance().getConfig().getString("fungun.options.style");
                    if (!"switchable".equalsIgnoreCase(styleOption)) break block22;
                    if (player.isSneaking()) {
                        String soundName;
                        new EffectsMenu().openMenu(player);
                        String openMessage = FunGun.getInstance().getConfigUtil().getMessage("messages.effects-menu.open-message");
                        if (!openMessage.isEmpty()) {
                            player.sendMessage(openMessage);
                        }
                        if (!(soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.open-sound")).isEmpty()) {
                            player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
                        }
                        break block23;
                    } else {
                        this.handleGunUse(player);
                    }
                    break block23;
                }
                this.handleGunUse(player);
            }
            event.setCancelled(true);
        }
        if (FunGunItem.isFunGunItem(itemInHand, FunGun.getInstance().getConfigUtil()) && event.getAction().toString().contains("LEFT")) {
            if (!abilitiesEnabled) {
                return;
            }
            String selectedAbility = DatabaseManager.getSelectedAbility(player.getUniqueId().toString());
            if (!"switchable".equalsIgnoreCase(abilityStyle)) {
                if ("none".equalsIgnoreCase(abilityStyle)) {
                    player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.abilities-menu.ability-not-selected"));
                    return;
                }
                ability = FunGun.getInstance().getConfigUtil().getAbilityHandler(abilityStyle);
                if (ability != null) {
                    ability.useAbility(player);
                } else {
                    Bukkit.getLogger().warning("&cNo ability found for: " + abilityStyle);
                }
            } else if (player.isSneaking()) {
                String soundName;
                new AbilitiesMenu().openMenu(player);
                String openMessage = FunGun.getInstance().getConfigUtil().getMessage("messages.abilities-menu.open-message");
                if (!openMessage.isEmpty()) {
                    player.sendMessage(openMessage);
                }
                if (!(soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("abilities-menu.open-sound")).isEmpty()) {
                    player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
                }
            } else {
                if (selectedAbility == null || selectedAbility.isEmpty()) {
                    if ("none".equalsIgnoreCase(defaultAbility)) {
                        player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.abilities-menu.ability-not-selected"));
                        return;
                    }
                    ability = FunGun.getInstance().getConfigUtil().getAbilityHandler(defaultAbility);
                } else {
                    ability = FunGun.getInstance().getConfigUtil().getAbilityHandler(selectedAbility);
                }
                if (ability != null) {
                    ability.useAbility(player);
                } else {
                    Bukkit.getLogger().warning("&cNo ability found for: " + (selectedAbility != null ? selectedAbility : defaultAbility));
                }
            }
            event.setCancelled(true);
        }
    }

    private void handleGunUse(Player player) {
        String selectedEffect;
        if (!player.hasPermission("fungun.use")) {
            player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.fungun.no-use-permission"));
            return;
        }
        if (this.cooldownHandler.hasEffectCooldown(player)) {
            double remainingCooldown = this.cooldownHandler.getRemainingEffectCooldown(player);
            if (remainingCooldown > 0.0 && remainingCooldown == Math.floor(remainingCooldown)) {
                String actionBarMessage;
                if (!FunGun.getInstance().getConfigUtil().getMessage("messages.fungun.effect-cooldown").isEmpty()) {
                    player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.fungun.effect-cooldown").replace("%cooldown%", String.valueOf((int)remainingCooldown)));
                }
                if ((actionBarMessage = ConfigUtil.configUtil.getMessage("messages.fungun.ability-cooldown-actionbar")) != null && !actionBarMessage.isEmpty()) {
                    actionBarMessage = actionBarMessage.replace("%cooldown%", String.valueOf((int)remainingCooldown));
                    player.sendActionBar(actionBarMessage);
                }
            }
            return;
        }
        String styleOption = FunGun.getInstance().getConfig().getString("fungun.options.style");
        if ("switchable".equalsIgnoreCase(styleOption)) {
            try {
                selectedEffect = DatabaseManager.getSelectedEffect(player.getUniqueId().toString());
            }
            catch (SQLException e) {
                player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.database-error"));
                e.printStackTrace();
                return;
            }
            if ((selectedEffect == null || selectedEffect.isEmpty()) && ((selectedEffect = FunGun.getInstance().getConfig().getString("fungun.options.default-style")) == null || selectedEffect.isEmpty())) {
                Bukkit.getLogger().warning("No default effect set in config for FunGun.");
                return;
            }
        } else {
            selectedEffect = styleOption;
            if (selectedEffect == null || selectedEffect.isEmpty()) {
                player.sendMessage(FunGun.getInstance().getConfigUtil().getMessage("messages.fungun.no-effect-configured"));
                return;
            }
        }
        this.launchFunGunProjectile(player);
        this.cooldownHandler.startEffectCooldown(player, FunGun.getInstance().getConfigUtil().getEffectCooldown(selectedEffect));
    }

    private void launchFunGunProjectile(Player player) {
        Snowball snowball = (Snowball)player.launchProjectile(Snowball.class);
        snowball.setVelocity(player.getLocation().getDirection().multiply(2));
        snowball.setMetadata("FunGunShot", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
        player.playSound(player.getLocation(), Sound.BLOCK_DISPENSER_DISPENSE, 1.0f, 1.0f);
    }
}

