/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.events;

import dev.dejvokep.boostedyaml.YamlDocument;
import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.database.DatabaseManager;
import java.sql.SQLException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ProjectileHitListener
implements Listener {
    private final JavaPlugin plugin;

    public ProjectileHitListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Snowball snowball;
        Projectile projectile = event.getEntity();
        if (projectile instanceof Snowball && (snowball = (Snowball)projectile).hasMetadata("FunGunShot")) {
            this.handleProjectileHit(snowball);
        }
    }

    private void handleProjectileHit(Snowball snowball) {
        YamlDocument effect;
        String selectedEffect;
        Player shooter;
        Player player = shooter = snowball.getShooter() instanceof Player ? (Player)snowball.getShooter() : null;
        if (shooter == null) {
            Bukkit.getLogger().warning("No shooter associated with the FunGun shot.");
            return;
        }
        World world = snowball.getWorld();
        Location location = snowball.getLocation();
        String styleOption = FunGun.getInstance().getConfig().getString("fungun.options.style");
        if ("switchable".equalsIgnoreCase(styleOption)) {
            try {
                selectedEffect = DatabaseManager.getSelectedEffect(shooter.getUniqueId().toString());
            }
            catch (SQLException e) {
                Bukkit.getLogger().severe("Failed to retrieve selected effect for player: " + e.getMessage());
                return;
            }
            if ((selectedEffect == null || selectedEffect.isEmpty()) && ((selectedEffect = FunGun.getInstance().getConfig().getString("fungun.options.default-style")) == null || selectedEffect.isEmpty())) {
                Bukkit.getLogger().warning("No default effect set in config for FunGun.");
                return;
            }
        } else {
            selectedEffect = styleOption;
            if (selectedEffect == null || selectedEffect.isEmpty()) {
                Bukkit.getLogger().warning("No effect configured in the config file.");
                return;
            }
        }
        if ((effect = FunGun.getInstance().getConfigUtil().getEffect(selectedEffect)) != null) {
            this.applyEffect(world, location, effect);
        } else {
            Bukkit.getLogger().warning("Unknown FunGun effect: " + selectedEffect);
        }
    }

    private void applyEffect(World world, Location location, YamlDocument effect) {
        String[] parts;
        List sounds = effect.getStringList("sounds");
        List particles = effect.getStringList("particles");
        for (String sound : sounds) {
            parts = sound.split(",");
            Sound effectSound = Sound.valueOf((String)parts[0]);
            float volume = Float.parseFloat(parts[1]);
            float pitch = Float.parseFloat(parts[2]);
            world.playSound(location, effectSound, volume, pitch);
        }
        for (String particleConfig : particles) {
            parts = particleConfig.split(",");
            if (parts.length < 6) {
                Bukkit.getLogger().warning("Particle config has insufficient data: " + particleConfig);
                continue;
            }
            Particle effectParticle = Particle.valueOf((String)parts[0]);
            int count = Integer.parseInt(parts[1]);
            double offsetX = Double.parseDouble(parts[2]);
            double offsetY = Double.parseDouble(parts[3]);
            double offsetZ = Double.parseDouble(parts[4]);
            if (effectParticle == Particle.REDSTONE) {
                try {
                    String[] colorParts = parts[5].split(",");
                    if (colorParts.length != 3) {
                        throw new IllegalArgumentException("Invalid color format for REDSTONE particle.");
                    }
                    int red = Integer.parseInt(colorParts[0].trim());
                    int green = Integer.parseInt(colorParts[1].trim());
                    int blue = Integer.parseInt(colorParts[2].trim());
                    if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
                        throw new IllegalArgumentException("RGB values must be between 0 and 255.");
                    }
                    Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)red, (int)green, (int)blue), 1.0f);
                    world.spawnParticle(effectParticle, location, count, offsetX, offsetY, offsetZ, (Object)dustOptions);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (effectParticle == Particle.BLOCK_CRACK || effectParticle == Particle.BLOCK_DUST || effectParticle == Particle.FALLING_DUST) {
                try {
                    Material material = Material.matchMaterial((String)parts[5]);
                    if (material == null) {
                        throw new IllegalArgumentException("Invalid block type: " + parts[5]);
                    }
                    BlockData blockData = material.createBlockData();
                    world.spawnParticle(effectParticle, location, count, offsetX, offsetY, offsetZ, (Object)blockData);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                continue;
            }
            double extra = Double.parseDouble(parts[5]);
            world.spawnParticle(effectParticle, location, count, offsetX, offsetY, offsetZ, extra);
        }
    }
}

