/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.events;

import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.model.FunGunItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.inventory.PlayerInventory;

public class WorldChangeListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        int slot = FunGun.getInstance().getConfigUtil().getConfig().getInt("fungun.options.slot") - 1;
        if (slot <= 0 || slot > 9) {
            Bukkit.getLogger().warning("Invalid slot number in config.yml. Must be between 1 and 9.");
            return;
        }
        if (FunGunItem.isWorldDisabled(player.getWorld()) && FunGunItem.isFunGunItem(inventory.getItem(slot), FunGun.getInstance().getConfigUtil())) {
            inventory.setItem(slot, null);
        }
        if (!FunGunItem.isWorldDisabled(player.getWorld())) {
            player.getInventory().setItem(slot, FunGunItem.createFunGunItem(FunGun.getInstance().getConfigUtil()));
        }
    }
}

