/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.guis;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.triumphteam.gui.builder.gui.PaginatedBuilder;
import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import dev.triumphteam.gui.guis.PaginatedGui;
import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.database.DatabaseManager;
import hu.kxtsoo.fungun.reflection.ClassUtils;
import hu.kxtsoo.fungun.util.ChatUtil;
import hu.kxtsoo.fungun.util.ConfigUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

public class EffectsMenu {
    public void openMenu(Player player) throws SQLException {
        String displayName;
        Material displayItem;
        String displayItemStr;
        ItemMeta meta;
        int customModelData;
        ConfigUtil configUtil = FunGun.getInstance().getConfigUtil();
        YamlDocument guis = configUtil.getGUIs();
        String title = guis.getString("effects-menu.title", "&aFunGun Effects Menu");
        title = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)title) : guis.getString("effects-menu.title", "&aFunGun Effects Menu");
        title = ChatUtil.colorizeHex(title);
        int rows = guis.getInt("effects-menu.rows", Integer.valueOf(3));
        int totalSlots = rows * 9;
        int maxEffectSlot = guis.getInt("effects-menu.max-item-slot", Integer.valueOf(totalSlots - 1));
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().title(LegacyComponentSerializer.legacySection().deserialize(title).decoration(TextDecoration.ITALIC, false))).rows(rows)).pageSize(maxEffectSlot).create();
        ArrayList<String> effectKeys = new ArrayList<String>(configUtil.getEffectsMap().keySet());
        String prevItem = guis.getString("effects-menu.navigation.previous-page.item", "ARROW");
        String nextItem = guis.getString("effects-menu.navigation.next-page.item", "ARROW");
        List prevSlots = guis.getIntList("effects-menu.navigation.previous-page.slots");
        List nextSlots = guis.getIntList("effects-menu.navigation.next-page.slots");
        Material prevMaterial = Material.valueOf((String)prevItem);
        Material nextMaterial = Material.valueOf((String)nextItem);
        String previousPageName = guis.getString("effects-menu.navigation.previous-page.name", "&aPrevious Page");
        previousPageName = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)previousPageName) : guis.getString("effects-menu.navigation.previous-page.name", "&aPrevious Page");
        previousPageName = ChatUtil.colorizeHex(previousPageName);
        List<String> previousPageLore = guis.getStringList("effects-menu.navigation.previous-page.lore").stream().map(line -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
            }
            return line;
        }).map(ChatUtil::colorizeHex).toList();
        GuiItem previousPage = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(prevMaterial).name(LegacyComponentSerializer.legacySection().deserialize(previousPageName).decoration(TextDecoration.ITALIC, false))).lore(previousPageLore.stream().map(line -> (TextComponent)LegacyComponentSerializer.legacySection().deserialize((String)line).decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList()))).asGuiItem(event -> {
            gui.previous();
            String soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.navigation.previous-page.sound");
            if (!soundName.isEmpty()) {
                player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
            }
            gui.update();
            event.setCancelled(true);
        });
        String nextPageName = guis.getString("effects-menu.navigation.next-page.name", "&aNext Page");
        nextPageName = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)nextPageName) : guis.getString("effects-menu.navigation.next-page.name", "&aNext Page");
        nextPageName = ChatUtil.colorizeHex(nextPageName);
        List<String> nextPageLore = guis.getStringList("effects-menu.navigation.next-page.lore").stream().map(line -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
            }
            return line;
        }).map(ChatUtil::colorizeHex).toList();
        GuiItem nextPage = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(nextMaterial).name(LegacyComponentSerializer.legacySection().deserialize(nextPageName).decoration(TextDecoration.ITALIC, false))).lore(nextPageLore.stream().map(line -> (TextComponent)LegacyComponentSerializer.legacySection().deserialize((String)line).decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList()))).asGuiItem(event -> {
            gui.next();
            String soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.navigation.next-page.sound");
            if (!soundName.isEmpty()) {
                player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
            }
            gui.update();
            event.setCancelled(true);
        });
        if (guis.contains("effects-menu.navigation.previous-page.custom-model-data")) {
            customModelData = guis.getInt("effects-menu.navigation.previous-page.custom-model-data");
            meta = previousPage.getItemStack().getItemMeta();
            if (meta != null) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                previousPage.getItemStack().setItemMeta(meta);
            }
        }
        if (guis.contains("effects-menu.navigation.next-page.custom-model-data")) {
            customModelData = guis.getInt("effects-menu.navigation.next-page.custom-model-data");
            meta = nextPage.getItemStack().getItemMeta();
            if (meta != null) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
                nextPage.getItemStack().setItemMeta(meta);
            }
        }
        Iterator customModelData2 = prevSlots.iterator();
        while (customModelData2.hasNext()) {
            int slot = (Integer)customModelData2.next();
            gui.setItem(slot, previousPage);
        }
        customModelData2 = nextSlots.iterator();
        while (customModelData2.hasNext()) {
            int slot = (Integer)customModelData2.next();
            gui.setItem(slot, nextPage);
        }
        List closeSlots = guis.getIntList("effects-menu.close-item.slots");
        String closeItem = guis.getString("effects-menu.close-item.item", "BARRIER");
        Material closeMaterial = Material.valueOf((String)closeItem);
        String closeMenuName = guis.getString("effects-menu.close-item.name", "&cClose Menu");
        closeMenuName = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)closeMenuName) : guis.getString("effects-menu.close-item.name", "&cClose Menu");
        closeMenuName = ChatUtil.colorizeHex(closeMenuName);
        List<String> closeLore = guis.getStringList("effects-menu.close-item.lore").stream().map(line -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
            }
            return line;
        }).map(ChatUtil::colorizeHex).toList();
        GuiItem closeMenu = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(closeMaterial).name(LegacyComponentSerializer.legacySection().deserialize(closeMenuName).decoration(TextDecoration.ITALIC, false))).lore(closeLore.stream().map(line -> (TextComponent)LegacyComponentSerializer.legacySection().deserialize((String)line).decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList()))).asGuiItem(event -> {
            player.closeInventory();
            String soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.close-item.sound");
            if (!soundName.isEmpty()) {
                player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
            }
            event.setCancelled(true);
        });
        if (guis.contains("effects-menu.close-item.custom-model-data")) {
            int customModelData3 = guis.getInt("effects-menu.close-item.custom-model-data");
            ItemMeta meta2 = closeMenu.getItemStack().getItemMeta();
            if (meta2 != null) {
                meta2.setCustomModelData(Integer.valueOf(customModelData3));
                closeMenu.getItemStack().setItemMeta(meta2);
            }
        }
        Iterator customModelData3 = closeSlots.iterator();
        while (customModelData3.hasNext()) {
            int slot = (Integer)customModelData3.next();
            gui.setItem(slot, closeMenu);
        }
        Section decorations = guis.getSection("effects-menu.decoration");
        if (decorations != null) {
            for (String key : decorations.getRoutesAsStrings(false)) {
                Section decoration = decorations.getSection(key);
                displayItemStr = decoration.getString("item", "STONE");
                try {
                    displayItem = Material.valueOf((String)displayItemStr);
                }
                catch (IllegalArgumentException e) {
                    displayItem = Material.BEDROCK;
                }
                displayName = decoration.getString("title", "&r");
                displayName = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)displayName) : decoration.getString("title", "&r");
                displayName = ChatUtil.colorizeHex(displayName);
                List lore = decoration.getStringList("lore").stream().map(line -> {
                    if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                        return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                    }
                    return ChatUtil.colorizeHex(line);
                }).collect(Collectors.toList());
                int slot = decoration.getInt("slot", Integer.valueOf(0));
                GuiItem decorativeItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(displayItem).name(Component.text(displayName))).lore(lore.stream().map(Component::text).collect(Collectors.toList()))).asGuiItem(event -> event.setCancelled(true));
                if (decoration.contains("custommodeldata")) {
                    int customModelData4 = decoration.getInt("custommodeldata");
                    ItemMeta meta3 = decorativeItem.getItemStack().getItemMeta();
                    if (meta3 != null) {
                        meta3.setCustomModelData(Integer.valueOf(customModelData4));
                        decorativeItem.getItemStack().setItemMeta(meta3);
                    }
                }
                gui.setItem(slot, decorativeItem);
            }
        }
        for (String effectKey : effectKeys) {
            YamlDocument effectDoc = configUtil.getEffect(effectKey);
            if (!effectDoc.getBoolean("effect.enabled", Boolean.valueOf(true)).booleanValue()) continue;
            displayItemStr = effectDoc.getString("effect.display.display-item", "BLAZE_ROD");
            try {
                displayItem = Material.valueOf((String)displayItemStr);
            }
            catch (IllegalArgumentException e) {
                displayItem = Material.BEDROCK;
            }
            displayName = effectDoc.getString("effect.display.display-name", "&cUnknown Effect");
            displayName = ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)displayName) : effectDoc.getString("effect.display.display-name", "&cUnknown Effect");
            displayName = ChatUtil.colorizeHex(displayName);
            List descriptionList = effectDoc.getStringList("effect.display.description").stream().map(line -> {
                if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                    return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                }
                return ChatUtil.colorizeHex(line);
            }).collect(Collectors.toList());
            ArrayList<String> lore = new ArrayList<String>();
            String itemDisplayName = "";
            if (!player.hasPermission("fungun.effect." + effectKey)) {
                itemDisplayName = ChatUtil.colorizeHex(guis.getString("effects-menu.item-template.no-permission.title", "%display-name%").replace("%display-name%", displayName));
                loreTemplate = guis.getStringList("effects-menu.item-template.no-permission.description").stream().map(line -> {
                    if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                        return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                    }
                    return ChatUtil.colorizeHex(line);
                }).toList();
                for (String line2 : loreTemplate) {
                    if (line2.contains("%description%")) {
                        for (String descLine : descriptionList) {
                            lore.add(ChatUtil.colorizeHex(line2.replace("%description%", descLine.trim())));
                        }
                        continue;
                    }
                    lore.add(ChatUtil.colorizeHex(line2));
                }
            } else if (DatabaseManager.isEffectSelected(player.getUniqueId().toString(), effectKey)) {
                itemDisplayName = ChatUtil.colorizeHex(guis.getString("effects-menu.item-template.selected.title", "%display-name%").replace("%display-name%", displayName));
                loreTemplate = guis.getStringList("effects-menu.item-template.selected.description").stream().map(line -> {
                    if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                        return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                    }
                    return ChatUtil.colorizeHex(line);
                }).collect(Collectors.toList());
                for (String line2 : loreTemplate) {
                    if (line2.contains("%description%")) {
                        for (String descLine : descriptionList) {
                            lore.add(ChatUtil.colorizeHex(line2.replace("%description%", descLine.trim())));
                        }
                        continue;
                    }
                    lore.add(ChatUtil.colorizeHex(line2));
                }
            } else {
                itemDisplayName = ChatUtil.colorizeHex(guis.getString("effects-menu.item-template.unselected.title", "%display-name%").replace("%display-name%", displayName));
                loreTemplate = guis.getStringList("effects-menu.item-template.unselected.description").stream().map(line -> {
                    if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                        return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
                    }
                    return ChatUtil.colorizeHex(line);
                }).collect(Collectors.toList());
                for (String line2 : loreTemplate) {
                    if (line2.contains("%description%")) {
                        for (String descLine : descriptionList) {
                            lore.add(ChatUtil.colorizeHex(line2.replace("%description%", descLine.trim())));
                        }
                        continue;
                    }
                    lore.add(ChatUtil.colorizeHex(line2));
                }
            }
            String finalDisplayName = displayName;
            GuiItem guiItem = ((ItemBuilder)((ItemBuilder)ItemBuilder.from(displayItem).name(LegacyComponentSerializer.legacySection().deserialize(itemDisplayName).decoration(TextDecoration.ITALIC, false))).lore(lore.stream().map(line -> (TextComponent)LegacyComponentSerializer.legacySection().deserialize((String)line).decoration(TextDecoration.ITALIC, false)).collect(Collectors.toList()))).asGuiItem(event -> {
                try {
                    if (!player.hasPermission("fungun.effect." + effectKey)) {
                        String soundName;
                        if (!configUtil.getMessage("messages.effects-menu.effect-no-permission").isEmpty()) {
                            player.sendMessage(configUtil.getMessage("messages.effects-menu.effect-no-permission").replace("%effect%", finalDisplayName));
                        }
                        if (!(soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.item-template.no-permission.sound")).isEmpty()) {
                            player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
                        }
                    } else if (DatabaseManager.isEffectSelected(player.getUniqueId().toString(), effectKey)) {
                        String soundName;
                        if (!configUtil.getMessage("messages.effects-menu.effect-already-selected").isEmpty()) {
                            player.sendMessage(configUtil.getMessage("messages.effects-menu.effect-already-selected").replace("%effect%", finalDisplayName));
                        }
                        if (!(soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.item-template.selected.sound")).isEmpty()) {
                            player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
                        }
                    } else {
                        String soundName;
                        DatabaseManager.saveSelectedEffect(player.getUniqueId().toString(), effectKey);
                        if (!configUtil.getMessage("messages.effects-menu.effect-select").isEmpty()) {
                            player.sendMessage(configUtil.getMessage("messages.effects-menu.effect-select").replace("%effect%", finalDisplayName));
                        }
                        if (!(soundName = FunGun.getInstance().getConfigUtil().getGUIs().getString("effects-menu.item-template.unselected.sound")).isEmpty()) {
                            player.playSound(player.getLocation(), soundName, 1.0f, 1.0f);
                        }
                        this.openMenu(player);
                    }
                }
                catch (SQLException e) {
                    configUtil.getMessage("messages.database-error");
                }
                event.setCancelled(true);
            });
            gui.addItem(guiItem);
        }
        gui.disableAllInteractions();
        gui.open((HumanEntity)player);
    }
}

