/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.manager;

import hu.kxtsoo.fungun.manager.SchedulerManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class CooldownManager {
    private final Map<Player, Long> effectCooldowns = new HashMap<Player, Long>();
    private final Map<Player, Long> abilityCooldowns = new HashMap<Player, Long>();
    private final Map<Player, Long> lastCooldownMessage = new HashMap<Player, Long>();
    private final JavaPlugin plugin;

    public CooldownManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void startEffectCooldown(Player player, int seconds) {
        long cooldownEnd = System.currentTimeMillis() + (long)(seconds * 1000);
        this.effectCooldowns.put(player, cooldownEnd);
        this.lastCooldownMessage.put(player, 0L);
        SchedulerManager.runAsyncLater(() -> this.clearEffectCooldown(player), (long)seconds * 20L);
    }

    public void startAbilityCooldown(Player player, int seconds) {
        long cooldownEnd = System.currentTimeMillis() + (long)(seconds * 1000);
        this.abilityCooldowns.put(player, cooldownEnd);
        this.lastCooldownMessage.put(player, 0L);
        SchedulerManager.runAsyncLater(() -> this.clearAbilityCooldown(player), (long)seconds * 20L);
    }

    public boolean hasEffectCooldown(Player player) {
        return this.effectCooldowns.containsKey(player) && this.effectCooldowns.get(player) > System.currentTimeMillis();
    }

    public boolean hasAbilityCooldown(Player player) {
        return this.abilityCooldowns.containsKey(player) && this.abilityCooldowns.get(player) > System.currentTimeMillis();
    }

    public int getRemainingEffectCooldown(Player player) {
        long remainingMillis;
        int remainingSeconds;
        if (this.hasEffectCooldown(player) && this.shouldSendCooldownMessage(player, remainingSeconds = (int)((remainingMillis = this.effectCooldowns.get(player) - System.currentTimeMillis()) / 1000L))) {
            return remainingSeconds;
        }
        return 0;
    }

    public int getRemainingAbilityCooldown(Player player) {
        long remainingMillis;
        int remainingSeconds;
        if (this.hasAbilityCooldown(player) && this.shouldSendCooldownMessage(player, remainingSeconds = (int)((remainingMillis = this.abilityCooldowns.get(player) - System.currentTimeMillis()) / 1000L))) {
            return remainingSeconds;
        }
        return 0;
    }

    public void clearEffectCooldown(Player player) {
        this.effectCooldowns.remove(player);
    }

    public void clearAbilityCooldown(Player player) {
        this.abilityCooldowns.remove(player);
    }

    private boolean shouldSendCooldownMessage(Player player, int remainingSeconds) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (!this.lastCooldownMessage.containsKey(player) || currentTime - this.lastCooldownMessage.get(player) >= 1L) {
            this.lastCooldownMessage.put(player, currentTime);
            return true;
        }
        return false;
    }
}

