/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.manager;

import hu.kxtsoo.fungun.FunGun;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class SchedulerManager {
    private static boolean isFolia;

    public static void run(Runnable runnable) {
        if (isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)FunGun.getInstance(), runnable);
        } else {
            Bukkit.getScheduler().runTask((Plugin)FunGun.getInstance(), runnable);
        }
    }

    public static void nrun(Runnable runnable) {
        if (isFolia) {
            Bukkit.getAsyncScheduler().runNow((Plugin)FunGun.getInstance(), task -> Bukkit.getScheduler().runTask((Plugin)FunGun.getInstance(), runnable));
        } else {
            Bukkit.getScheduler().runTask((Plugin)FunGun.getInstance(), runnable);
        }
    }

    public static void runAsync(Runnable runnable) {
        if (isFolia) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)FunGun.getInstance(), runnable);
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)FunGun.getInstance(), runnable);
        }
    }

    public static Task runLater(Runnable runnable, long delayTicks) {
        if (isFolia) {
            return new Task(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)FunGun.getInstance(), t -> runnable.run(), delayTicks));
        }
        return new Task(Bukkit.getScheduler().runTaskLater((Plugin)FunGun.getInstance(), runnable, delayTicks));
    }

    public static Task runAsyncLater(Runnable runnable, long delayTicks) {
        if (isFolia) {
            return new Task(Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)FunGun.getInstance(), t -> runnable.run(), delayTicks));
        }
        return new Task(Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)FunGun.getInstance(), runnable, delayTicks));
    }

    public static Task runTimer(Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia) {
            return new Task(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)FunGun.getInstance(), t -> runnable.run(), delayTicks < 1L ? 1L : delayTicks, periodTicks));
        }
        return new Task(Bukkit.getScheduler().runTaskTimer((Plugin)FunGun.getInstance(), runnable, delayTicks, periodTicks));
    }

    public static Task runAsyncTimer(Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia) {
            return new Task(Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)FunGun.getInstance(), t -> runnable.run(), delayTicks < 1L ? 1L : delayTicks, periodTicks));
        }
        return new Task(Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)FunGun.getInstance(), runnable, delayTicks, periodTicks));
    }

    public static boolean isFolia() {
        return isFolia;
    }

    static {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
        }
        catch (ClassNotFoundException e) {
            isFolia = false;
        }
    }

    public static class Task {
        private ScheduledTask foliaTask;
        private BukkitTask bukkitTask;

        Task(ScheduledTask foliaTask) {
            this.foliaTask = foliaTask;
        }

        Task(BukkitTask bukkitTask) {
            this.bukkitTask = bukkitTask;
        }

        public void cancel() {
            if (this.foliaTask != null) {
                this.foliaTask.cancel();
            } else if (this.bukkitTask != null) {
                this.bukkitTask.cancel();
            }
        }
    }
}

