/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.reflection;

import hu.kxtsoo.fungun.reflection.UnsafeUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public enum ClassUtils {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    private final Unsafe unsafe = UnsafeUtils.INSTANCE.unsafe();
    private final HashMap<String, Boolean> CLASS_CACHE = new HashMap();

    public boolean classExists(@NotNull String className) {
        return this.CLASS_CACHE.computeIfAbsent(className, name -> {
            try {
                Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        });
    }

    public <T> T newInstance(String clazz) {
        try {
            return this.newInstance(Class.forName(clazz));
        }
        catch (ClassNotFoundException exception) {
            this.log.error("Could not find class {}!", (Object)clazz, (Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException exception) {
            this.log.error("An unexpected error occurred while finding class {}!", (Object)clazz, (Object)exception);
            throw new RuntimeException(exception);
        }
    }

    public Field getDeclaredField(String clazz, String field) {
        Class<?> cl = this.getClass(clazz);
        try {
            return cl.getDeclaredField(field);
        }
        catch (NoSuchFieldException exception) {
            this.log.error("An unexpected error occurred while getting field {} of class {}!", new Object[]{field, clazz, exception});
            throw new RuntimeException(exception);
        }
    }

    public <T> T newInstance(Class<?> clazz) {
        try {
            return (T)this.unsafe.allocateInstance(clazz);
        }
        catch (InstantiationException exception) {
            this.log.error("Failed to initialize new instance of class {}!", (Object)clazz.getName(), (Object)exception);
            throw new RuntimeException(exception);
        }
    }
}

