/*
 * Decompiled with CFR 0.152.
 */
package hu.kxtsoo.fungun.util;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.dvs.versioning.BasicVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import hu.kxtsoo.fungun.FunGun;
import hu.kxtsoo.fungun.abilities.AbilityHandler;
import hu.kxtsoo.fungun.abilities.BatSwarmAbility;
import hu.kxtsoo.fungun.abilities.DashAbility;
import hu.kxtsoo.fungun.abilities.ExplosionAbility;
import hu.kxtsoo.fungun.abilities.MeteorAbility;
import hu.kxtsoo.fungun.abilities.MountFlightAbility;
import hu.kxtsoo.fungun.util.ChatUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigUtil {
    private final JavaPlugin plugin;
    public static ConfigUtil configUtil;
    private YamlDocument config;
    private YamlDocument effects;
    private YamlDocument guis;
    private YamlDocument messages;
    private YamlDocument hooks;
    private final Map<String, YamlDocument> effectsMap = new HashMap<String, YamlDocument>();
    private final Map<String, YamlDocument> abilitiesMap = new HashMap<String, YamlDocument>();

    public ConfigUtil(JavaPlugin plugin) {
        this.plugin = plugin;
        this.setupConfig();
        this.loadEffects();
        this.loadAbilities();
        this.setupGUIs();
        this.setupMessages();
        this.setupHooks();
    }

    public void setupHooks() {
        try {
            File hooksFile = new File(this.plugin.getDataFolder(), "hooks.yml");
            if (!hooksFile.exists()) {
                this.plugin.saveResource("hooks.yml", false);
            }
            this.hooks = YamlDocument.create((File)hooksFile, (InputStream)Objects.requireNonNull(this.plugin.getResource("hooks.yml")), (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setKeepAll(true).setVersioning((Versioning)new BasicVersioning("version")).build());
            this.hooks.update();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Error loading or creating hooks.yml: " + ex.getMessage());
        }
    }

    public void setupConfig() {
        try {
            File configFile = new File(this.plugin.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                this.plugin.saveResource("config.yml", false);
            }
            this.config = YamlDocument.create((File)configFile, (InputStream)Objects.requireNonNull(this.plugin.getResource("config.yml")), (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setKeepAll(true).setVersioning((Versioning)new BasicVersioning("config-version")).build());
            this.config.update();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Error loading or creating config.yml: " + ex.getMessage());
        }
    }

    public void loadEffects() {
        String[] effectFiles;
        File effectsFolder = new File(this.plugin.getDataFolder(), "effects");
        if (!effectsFolder.exists()) {
            effectsFolder.mkdirs();
        }
        this.effectsMap.clear();
        for (String effectFileName : effectFiles = new String[]{"abyssaldepths.yml", "aqua.yml", "aurora.yml", "cherryblossom.yml", "cosmic.yml", "crimsonflare.yml", "crystalfrost.yml", "eclipse.yml", "embers.yml", "fiery.yml", "frosty.yml", "galactic.yml", "glaregrove.yml", "glaremoss.yml", "hellfire.yml", "junglespirit.yml", "lava.yml", "magicforest.yml", "mystical.yml", "mythicflames.yml", "netherwisp.yml", "phantomwhirl.yml", "soulstorm.yml", "sparklingglow.yml", "stormy.yml", "tempestfury.yml", "twilightblossom.yml", "wardenfury.yml", "wildfiretempest.yml", "wispflight.yml", "wizardsfantasy.yml"}) {
            File effectFile = new File(effectsFolder, effectFileName);
            if (effectFile.exists()) continue;
            this.plugin.saveResource("effects/" + effectFileName, false);
        }
        File[] loadedEffectFiles = effectsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (loadedEffectFiles != null && loadedEffectFiles.length > 0) {
            for (File effectFile : loadedEffectFiles) {
                try {
                    String effectName = effectFile.getName().replace(".yml", "").toUpperCase();
                    YamlDocument effectDocument = YamlDocument.create((File)effectFile, (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("effects-version")).build());
                    this.effectsMap.put(effectName, effectDocument);
                }
                catch (IOException ex) {
                    this.plugin.getLogger().severe("Error loading effect file: " + effectFile.getName() + " - " + ex.getMessage());
                }
            }
        } else {
            this.plugin.getLogger().warning("No effect files found in the effects folder.");
        }
    }

    public void loadAbilities() {
        String[] abilitiesFiles;
        File abilitiesFolder = new File(this.plugin.getDataFolder(), "abilities");
        if (!abilitiesFolder.exists()) {
            abilitiesFolder.mkdirs();
        }
        this.abilitiesMap.clear();
        for (String abilitiesFileName : abilitiesFiles = new String[]{"dash.yml", "explosion.yml", "meteor.yml", "mountflight.yml", "batswarm.yml"}) {
            File effectFile = new File(abilitiesFolder, abilitiesFileName);
            if (effectFile.exists()) continue;
            this.plugin.saveResource("abilities/" + abilitiesFileName, false);
        }
        File[] loadedAbilityFiles = abilitiesFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (loadedAbilityFiles != null && loadedAbilityFiles.length > 0) {
            for (File abilityFile : loadedAbilityFiles) {
                try {
                    String abilityName = abilityFile.getName().replace(".yml", "").toUpperCase();
                    YamlDocument abilityDocument = YamlDocument.create((File)abilityFile, (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("abilities-version")).build());
                    this.abilitiesMap.put(abilityName, abilityDocument);
                }
                catch (IOException ex) {
                    this.plugin.getLogger().severe("Error loading ability file: " + abilityFile.getName() + " - " + ex.getMessage());
                }
            }
        } else {
            this.plugin.getLogger().warning("No ability files found in the abilities folder.");
        }
    }

    public void setupGUIs() {
        try {
            File guisFile = new File(this.plugin.getDataFolder(), "guis.yml");
            if (!guisFile.exists()) {
                this.plugin.saveResource("guis.yml", false);
            }
            this.guis = YamlDocument.create((File)guisFile, (InputStream)Objects.requireNonNull(this.plugin.getResource("guis.yml")), (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setKeepAll(true).setVersioning((Versioning)new BasicVersioning("guis-version")).build());
            this.guis.update();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Error loading or creating guis.yml: " + ex.getMessage());
        }
    }

    public void setupMessages() {
        this.generateDefaultLocales();
        String locale = this.config.getString("locale", "en");
        File messagesFile = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "locale", locale + ".yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("locale" + File.separator + locale + ".yml", false);
        }
        try {
            this.messages = YamlDocument.create((File)messagesFile, (InputStream)Objects.requireNonNull(this.plugin.getResource("locale/" + locale + ".yml")), (GeneralSettings)GeneralSettings.builder().setUseDefaults(false).build(), (LoaderSettings)LoaderSettings.DEFAULT, (DumperSettings)DumperSettings.DEFAULT, (UpdaterSettings)UpdaterSettings.builder().setVersioning((Versioning)new BasicVersioning("messages-version")).setKeepAll(true).build());
            this.messages.update();
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Error loading or creating message files " + ex.getMessage());
        }
    }

    private void generateDefaultLocales() {
        String[] locales;
        for (String locale : locales = new String[]{"en", "hu"}) {
            File localeFile = new File(this.plugin.getDataFolder(), "locale" + File.separator + locale + ".yml");
            if (localeFile.exists()) continue;
            this.plugin.saveResource("locale" + File.separator + locale + ".yml", false);
        }
    }

    public String getMessage(String key) {
        Object messageObj = this.messages.get(key, (Object)"Message not found");
        if (messageObj instanceof String) {
            String message = ChatUtil.colorizeHex((String)messageObj);
            String prefix = ChatUtil.colorizeHex(this.config.getString("prefix", ""));
            if (message.contains("%prefix%")) {
                return message.replace("%prefix%", prefix);
            }
            return message;
        }
        if (messageObj instanceof List) {
            List<String> messageList = (List<String>)messageObj;
            String prefix = ChatUtil.colorizeHex(this.config.getString("prefix", ""));
            messageList = messageList.stream().map(ChatUtil::colorizeHex).map(msg -> msg.contains("%prefix%") ? msg.replace("%prefix%", prefix) : msg).toList();
            return String.join((CharSequence)"\n", messageList);
        }
        return "Invalid message format";
    }

    public YamlDocument getConfig() {
        return this.config;
    }

    public YamlDocument getEffect(String effectName) {
        return this.effectsMap.get(effectName.toUpperCase());
    }

    public int getEffectCount() {
        return this.effectsMap.size();
    }

    public Map<String, YamlDocument> getEffectsMap() {
        return this.effectsMap;
    }

    public int getEffectCooldown(String effectName) {
        YamlDocument effectConfig = this.effectsMap.get(effectName.toUpperCase());
        if (effectConfig != null) {
            return effectConfig.getInt("effect.options.cooldown", Integer.valueOf(5));
        }
        return 5;
    }

    public YamlDocument getAbility(String abilityName) {
        return this.abilitiesMap.get(abilityName.toUpperCase());
    }

    public Map<String, YamlDocument> getAbilitiesMap() {
        return this.abilitiesMap;
    }

    public int getAbilityCount() {
        return this.abilitiesMap.size();
    }

    public AbilityHandler getAbilityHandler(String abilityName) {
        YamlDocument abilityConfig = this.abilitiesMap.get(abilityName.toUpperCase());
        if (abilityConfig != null) {
            switch (abilityName.toUpperCase()) {
                case "DASH": {
                    return new DashAbility(FunGun.getInstance().getCooldownManager());
                }
                case "EXPLOSION": {
                    return new ExplosionAbility(FunGun.getInstance().getCooldownManager(), FunGun.getInstance());
                }
                case "METEOR": {
                    return new MeteorAbility(FunGun.getInstance().getCooldownManager(), FunGun.getInstance());
                }
                case "MOUNTFLIGHT": {
                    return new MountFlightAbility(FunGun.getInstance().getCooldownManager(), FunGun.getInstance());
                }
                case "BATSWARM": {
                    return new BatSwarmAbility(FunGun.getInstance().getCooldownManager(), FunGun.getInstance());
                }
            }
            FunGun.getInstance().getLogger().warning("No handler found for ability: " + abilityName);
            return null;
        }
        return null;
    }

    public YamlDocument getGUIs() {
        return this.guis;
    }

    public YamlDocument getHook() {
        return this.hooks;
    }

    public void reloadConfig() {
        this.setupConfig();
        this.setupMessages();
        this.setupGUIs();
    }

    public void reloadEffects() {
        this.loadEffects();
    }

    public void reloadAbilities() {
        this.loadAbilities();
    }
}

