/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.xalcon.torchmaster.ModRegistry;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.platform.Services;

public class FeralFlareLanternBlockEntity
extends BlockEntity {
    private int ticks;
    private boolean useLineOfSight;
    private List<BlockPos> childLights = new ArrayList<BlockPos>();

    public FeralFlareLanternBlockEntity(BlockPos pos, BlockState state) {
        super(ModRegistry.tileFeralFlareLantern.get(), pos, state);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.removeChildLights();
    }

    public void tick() {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        if (this.level.isClientSide() || ++this.ticks % config.getFeralFlareTickRate() != 0) {
            return;
        }
        if (this.childLights.size() > config.getFeralFlareLanternLightCountHardcap()) {
            return;
        }
        this.ticks = 0;
        int radius = config.getFeralFlareRadius();
        int diameter = radius * 2;
        int x = radius - this.level.random.nextInt(diameter) + this.worldPosition.getX();
        int y = radius - this.level.random.nextInt(diameter) + this.worldPosition.getY();
        int z = radius - this.level.random.nextInt(diameter) + this.worldPosition.getZ();
        BlockPos targetPos = new BlockPos(x, y, z);
        int surfaceHeight = this.level.getHeight(Heightmap.Types.WORLD_SURFACE, targetPos.getX(), targetPos.getZ());
        if (targetPos.getY() > surfaceHeight + 4) {
            targetPos = targetPos.atY(surfaceHeight).above(4);
        }
        int worldHeightCap = this.level.getHeight();
        if (targetPos.getY() > worldHeightCap) {
            targetPos = new BlockPos(targetPos.getX(), worldHeightCap - 1, targetPos.getZ());
        }
        if (!this.level.isLoaded(targetPos)) {
            return;
        }
        if (this.level.isEmptyBlock(targetPos) && this.level.getBrightness(LightLayer.BLOCK, targetPos) < config.getFeralFlareMinLightLevel()) {
            BlockPos hitPos;
            Vec3 end;
            Vec3 start;
            ClipContext rtxCtx;
            BlockHitResult rtResult;
            if (this.useLineOfSight && (rtResult = this.level.clip(rtxCtx = new ClipContext(start = new Vec3((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()).add(0.5, 0.5, 0.5), end = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()).add(0.5, 0.5, 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, CollisionContext.empty()))).getType() == HitResult.Type.BLOCK && ((hitPos = rtResult.getBlockPos()).getX() != this.worldPosition.getX() || hitPos.getY() != this.worldPosition.getY() || hitPos.getZ() != this.worldPosition.getZ())) {
                return;
            }
            if (this.level.setBlock(targetPos, ModRegistry.blockInvisibleLight.get().defaultBlockState(), 3)) {
                this.childLights.add(targetPos);
                this.setChanged();
            }
        }
    }

    public static <T extends BlockEntity> void dispatchTickBlockEntity(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof FeralFlareLanternBlockEntity) {
            ((FeralFlareLanternBlockEntity)blockEntity).tick();
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        int[] childLightsEncoded = new int[this.childLights.size()];
        int i = 0;
        for (BlockPos child : this.childLights) {
            childLightsEncoded[i++] = FeralFlareLanternBlockEntity.encodePosition(this.worldPosition, child);
        }
        output.putIntArray("lights", childLightsEncoded);
        output.putInt("ticks", this.ticks);
        output.putBoolean("useLoS", this.useLineOfSight);
    }

    public void loadAdditional(ValueInput input) {
        this.childLights.clear();
        Optional lightsEncoded = input.getIntArray("lights");
        lightsEncoded.ifPresentOrElse(le -> {
            for (int encodedLight : le) {
                this.childLights.add(FeralFlareLanternBlockEntity.decodePosition(this.worldPosition, encodedLight));
            }
        }, () -> Torchmaster.LOG.error("Error while loading lantern at {}, failed to decode internal light list", (Object)this.worldPosition));
        this.ticks = input.getInt("ticks").orElse(0);
        this.useLineOfSight = input.getBooleanOr("useLoS", false);
        super.loadAdditional(input);
    }

    public void setUseLineOfSight(boolean state) {
        Torchmaster.LOG.info("Current: {}, New: {}", (Object)this.useLineOfSight, (Object)state);
        this.useLineOfSight = state;
        this.setChanged();
        BlockState blockState = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, blockState, blockState, 3);
    }

    public boolean shouldUseLineOfSight() {
        return this.useLineOfSight;
    }

    public void removeChildLights() {
        if (this.level.isClientSide()) {
            return;
        }
        for (BlockPos pos : this.childLights) {
            if (this.level.getBlockState(pos).getBlock() != ModRegistry.blockInvisibleLight.get()) continue;
            this.level.removeBlock(pos, false);
        }
        this.childLights.clear();
    }

    private static int encodePosition(BlockPos origin, BlockPos target) {
        int x = target.getX() - origin.getX();
        int y = target.getY() - origin.getY();
        int z = target.getZ() - origin.getZ();
        return ((x & 0xFF) << 16) + ((y & 0xFF) << 8) + (z & 0xFF);
    }

    private static BlockPos decodePosition(BlockPos origin, int pos) {
        byte x = (byte)(pos >> 16 & 0xFF);
        byte y = (byte)(pos >> 8 & 0xFF);
        byte z = (byte)(pos & 0xFF);
        return origin.offset((int)x, (int)y, (int)z);
    }
}

