/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.EntityBlocker;
import net.xalcon.torchmaster.logic.EntityBlockerSerializer;

public class EntityBlockerSerializerRegistry {
    private static final Map<ResourceLocation, EntityBlockerSerializer<?>> serializers = new HashMap();

    public static void RegisterSerializer(ResourceLocation type, EntityBlockerSerializer<?> serializer) {
        if (serializers.containsKey(type)) {
            Torchmaster.LOG.error("Serializer with type '{}' was already registered", (Object)type);
            return;
        }
        serializers.put(type, serializer);
    }

    @Nullable
    public static EntityBlocker Deserialize(CompoundTag tag) {
        Optional typeStr = tag.getString("_type");
        if (typeStr.isEmpty()) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, empty type");
            return null;
        }
        ResourceLocation type = ResourceLocation.tryParse((String)((String)typeStr.get()));
        if (type == null) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, can't parse type '{}'", (Object)typeStr);
            return null;
        }
        EntityBlockerSerializer<?> serializer = serializers.get(type);
        if (serializer == null) {
            Torchmaster.LOG.error("Unable to deserialize EntityBlocker, type '{}' not found in registry", (Object)typeStr);
            return null;
        }
        return serializer.DeserializeFrom(tag);
    }

    @Nullable
    public static CompoundTag Serialize(EntityBlocker blocker) {
        CompoundTag tag = new CompoundTag();
        ResourceLocation type = blocker.getType();
        EntityBlockerSerializer<?> serializer = serializers.get(type);
        if (serializer == null) {
            Torchmaster.LOG.error("Serializer for type '{}' not found, unable to save data", (Object)type);
            return null;
        }
        serializer.SerializeInto(tag, blocker);
        tag.putString("_type", type.toString());
        return tag;
    }
}

