/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.blocks.EntityBlockingLightBlock;
import net.xalcon.torchmaster.blocks.FeralFlareLanternBlock;
import net.xalcon.torchmaster.blocks.FeralFlareLanternBlockEntity;
import net.xalcon.torchmaster.blocks.InvisibleLightBlock;
import net.xalcon.torchmaster.blocks.LightType;
import net.xalcon.torchmaster.items.TMItemBlock;
import net.xalcon.torchmaster.platform.RegistrationProvider;
import net.xalcon.torchmaster.platform.RegistryObject;
import net.xalcon.torchmaster.platform.Services;

public class ModRegistry {
    private static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.create(Registries.BLOCK, "torchmaster");
    private static final RegistrationProvider<Item> ITEMS = RegistrationProvider.create(Registries.ITEM, "torchmaster");
    private static final RegistrationProvider<BlockEntityType<?>> BLOCK_ENTITIES = RegistrationProvider.create(Registries.BLOCK_ENTITY_TYPE, "torchmaster");
    private static final RegistrationProvider<CreativeModeTab> CREATIVE_MODE_TABS = RegistrationProvider.create(Registries.CREATIVE_MODE_TAB, "torchmaster");
    public static RegistryObject<EntityBlockingLightBlock> blockMegaTorch;
    public static RegistryObject<EntityBlockingLightBlock> blockDreadLamp;
    public static RegistryObject<FeralFlareLanternBlock> blockFeralFlareLantern;
    public static RegistryObject<BlockEntityType<FeralFlareLanternBlockEntity>> tileFeralFlareLantern;
    public static RegistryObject<InvisibleLightBlock> blockInvisibleLight;
    public static RegistryObject<Item> itemMegaTorch;
    public static RegistryObject<Item> itemDreadLamp;
    public static RegistryObject<Item> itemFeralFlareLantern;
    private static CreativeModeTab tab;

    private ModRegistry() {
    }

    public static void initialize() {
        ArrayList<RegistryObject<Item>> creativeTabItems = new ArrayList<RegistryObject<Item>>();
        blockMegaTorch = BLOCKS.register("megatorch", () -> new EntityBlockingLightBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.WOOD).strength(1.0f, 1.0f).lightLevel(state -> 15).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Torchmaster.modLoc("megatorch"))), LightType.MegaTorch));
        itemMegaTorch = ModRegistry.fromBlock(blockMegaTorch);
        creativeTabItems.add(itemMegaTorch);
        blockDreadLamp = BLOCKS.register("dreadlamp", () -> new EntityBlockingLightBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).sound(SoundType.WOOD).strength(1.0f, 1.0f).lightLevel(state -> 15).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Torchmaster.modLoc("dreadlamp"))), LightType.DreadLamp));
        itemDreadLamp = ModRegistry.fromBlock(blockDreadLamp);
        creativeTabItems.add(itemDreadLamp);
        blockFeralFlareLantern = BLOCKS.register("feral_flare_lantern", () -> new FeralFlareLanternBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).sound(SoundType.LANTERN).strength(1.0f, 1.0f).lightLevel(state -> 15).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Torchmaster.modLoc("feral_flare_lantern")))));
        tileFeralFlareLantern = BLOCK_ENTITIES.register(blockFeralFlareLantern.getId().getPath(), () -> Services.PLATFORM.createBlockEntityType(FeralFlareLanternBlockEntity::new, (Block)blockFeralFlareLantern.get()));
        itemFeralFlareLantern = ModRegistry.fromBlock(blockFeralFlareLantern);
        creativeTabItems.add(itemFeralFlareLantern);
        blockInvisibleLight = BLOCKS.register("invisible_light", () -> new InvisibleLightBlock(BlockBehaviour.Properties.of().lightLevel(state -> 15).noCollision().replaceable().air().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Torchmaster.modLoc("invisible_light")))));
        CREATIVE_MODE_TABS.register("torchmaster", () -> Services.PLATFORM.createCreativeModeTab("torchmaster", creativeTabItems));
    }

    private static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block) {
        return ModRegistry.fromBlock(block, i -> {});
    }

    private static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block, Consumer<Item.Properties> propertiesConfig) {
        Item.Properties properties = new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)block.getId()));
        propertiesConfig.accept(properties);
        return ITEMS.register(block.getId().getPath(), () -> new TMItemBlock((Block)block.get(), properties));
    }
}

