/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.xalcon.torchmaster.EntityFilterList;
import net.xalcon.torchmaster.ModRegistry;
import net.xalcon.torchmaster.compat.VanillaCompat;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.logic.entityblocking.FilteredLightManager;
import net.xalcon.torchmaster.logic.entityblocking.IBlockingLightManager;
import net.xalcon.torchmaster.platform.Services;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Torchmaster {
    public static final EntityFilterList MegaTorchFilterRegistry = new EntityFilterList(ResourceLocation.fromNamespaceAndPath((String)"torchmaster", (String)"entity_filter/mega_torch"));
    public static final EntityFilterList DreadLampFilterRegistry = new EntityFilterList(ResourceLocation.fromNamespaceAndPath((String)"torchmaster", (String)"entity_filter/dread_lamp"));
    public static final Logger LOG = LoggerFactory.getLogger((String)"Torchmaster");

    public static ITorchmasterConfig getConfig() {
        return Services.PLATFORM.getConfig();
    }

    public static void init() {
        if (System.getProperty("torchmaster.enableDebugLogging", "0").equals("1")) {
            Configurator.setLevel((String)"Torchmaster", (Level)Level.DEBUG);
        } else {
            Configurator.setLevel((String)"Torchmaster", (Level)Level.INFO);
        }
        LOG.info("Initializing Torchmaster for platform {}", (Object)Services.PLATFORM.getPlatformName());
        LOG.info("Debug Logging Enabled: {}", (Object)LOG.isDebugEnabled());
        LOG.debug("If you can see this while the system property torchmaster.enableDebugLogging is not set to 1, report this on github!");
        ModRegistry.initialize();
    }

    public static Optional<IBlockingLightManager> getRegistryForLevel(net.minecraft.world.level.Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            String dimensionIdentifier = level.dimension().location().toDebugFileName();
            return Optional.of((IBlockingLightManager)serverLevel.getDataStorage().computeIfAbsent(FilteredLightManager.typeFor("lights_" + dimensionIdentifier)));
        }
        return Optional.empty();
    }

    public static void onWorldLoaded() {
        DreadLampFilterRegistry.clear();
        MegaTorchFilterRegistry.clear();
        VanillaCompat.registerDreadLampEntities(DreadLampFilterRegistry);
        VanillaCompat.registerTorchEntities(MegaTorchFilterRegistry);
        DreadLampFilterRegistry.applyListOverrides(Torchmaster.getConfig().getDreadLampEntityBlockListOverrides());
        MegaTorchFilterRegistry.applyListOverrides(Torchmaster.getConfig().getMegaTorchEntityBlockListOverrides());
    }

    public static ResourceLocation modLoc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"torchmaster", (String)path);
    }
}

