/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.events;

import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.events.EventResult;
import net.xalcon.torchmaster.events.EventResultContainer;
import net.xalcon.torchmaster.platform.Services;

public class TorchmasterEventHandler {
    private static boolean isPlayerTriggered(EntitySpawnReason spawnType) {
        switch (spawnType) {
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_ITEM_USE: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: 
            case TRIAL_SPAWNER: 
            case LOAD: 
            case DIMENSION_TRAVEL: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNaturalSpawn(EntitySpawnReason spawnType) {
        switch (spawnType) {
            default: {
                return true;
            }
            case BREEDING: 
            case DISPENSER: 
            case BUCKET: 
            case CONVERSION: 
            case SPAWN_ITEM_USE: 
            case TRIGGERED: 
            case COMMAND: 
            case EVENT: 
            case TRIAL_SPAWNER: 
            case LOAD: 
            case DIMENSION_TRAVEL: 
            case SPAWNER: 
            case STRUCTURE: 
            case MOB_SUMMONED: 
            case REINFORCEMENT: 
            case JOCKEY: 
        }
        return false;
    }

    public static void onCheckSpawn(EntitySpawnReason spawnType, Entity entity, Vec3 location, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        Torchmaster.LOG.debug("CheckSpawn - Reason: {}, Type: {}, Pos: {}/{}/{}", new Object[]{spawnType, EntityType.getKey((EntityType)entity.getType()), location.x, location.y, location.z});
        if (TorchmasterEventHandler.isPlayerTriggered(spawnType)) {
            return;
        }
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        if (config.getBlockOnlyNaturalSpawns() && !TorchmasterEventHandler.isNaturalSpawn(spawnType)) {
            return;
        }
        Level level = entity.level();
        EntityType entityType = entity.getType();
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockEntityType(entityType, entity.level(), location, spawnType)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking spawn of {}", (Object)EntityType.getKey((EntityType)entityType));
            } else {
                Torchmaster.LOG.debug("Allowed spawn of {}", (Object)EntityType.getKey((EntityType)entityType));
            }
        });
    }

    public static void onPlayerSpawnPhantoms(Player player, Vec3 location, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        Torchmaster.LOG.debug("PlayerSpawnPhantoms - Pos: {}/{}/{}", new Object[]{location.x, location.y, location.z});
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        Level level = player.level();
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockEntityType(EntityType.PHANTOM, level, player.position(), EntitySpawnReason.NATURAL)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking spawn of {}", (Object)EntityType.getKey((EntityType)EntityType.PHANTOM));
            } else {
                Torchmaster.LOG.debug("Allowed spawn of {}", (Object)EntityType.getKey((EntityType)EntityType.PHANTOM));
            }
        });
    }

    public static void onVillageSiege(Level level, Vec3 attemptedSpawnPos, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        if (!config.getBlockVillageSieges()) {
            return;
        }
        Torchmaster.LOG.debug("VillageSiegeEvent - Pos: {}", (Object)attemptedSpawnPos);
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockVillageZombieRaid(attemptedSpawnPos)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking village siege @ {}", (Object)attemptedSpawnPos);
            } else {
                Torchmaster.LOG.debug("Allowed village siege @ {}", (Object)attemptedSpawnPos);
            }
        });
    }

    public static void onPatrolMemberSpawn(ServerLevel level, Vec3 location, boolean leader, Entity entity, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        Torchmaster.LOG.debug("PatrolMemberSpawn - Pos: {}/{}/{}", new Object[]{location.x, location.y, location.z});
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        EntityType entityType = entity.getType();
        Torchmaster.getRegistryForLevel((Level)level).ifPresent(reg -> {
            if (reg.shouldBlockEntityType(entityType, (Level)level, location, EntitySpawnReason.NATURAL)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking spawn of {}, (Leader: {})", (Object)EntityType.getKey((EntityType)entityType), (Object)leader);
            } else {
                Torchmaster.LOG.debug("Allowed spawn of {}, (Leader: {})", (Object)EntityType.getKey((EntityType)entityType), (Object)leader);
            }
        });
    }

    public static void onServerLevelTickEnd(MinecraftServer server, BooleanSupplier haveTime) {
        for (ServerLevel level : server.getAllLevels()) {
            Torchmaster.getRegistryForLevel((Level)level).ifPresent(reg -> reg.onGlobalTick((Level)level));
        }
    }
}

