/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.Vec3;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.entityblocking.IBlockingLightManager;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.logic.entityblocking.LightSerializerRegistry;
import net.xalcon.torchmaster.logic.entityblocking.TorchInfo;

public class FilteredLightManager
extends SavedData
implements IBlockingLightManager {
    private final Map<String, IEntityBlockingLight> lights = new HashMap<String, IEntityBlockingLight>();
    private static final Codec<LightData> LIGHT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(LightData::key), (App)Codec.STRING.fieldOf("type").forGetter(LightData::type), (App)CompoundTag.CODEC.fieldOf("data").forGetter(LightData::data)).apply((Applicative)instance, LightData::new));
    private static final Codec<FilteredLightManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LIGHT_CODEC.listOf().fieldOf("lights").forGetter(FilteredLightManager::save)).apply((Applicative)instance, FilteredLightManager::load));

    private static FilteredLightManager load(List<LightData> lights) {
        FilteredLightManager mgr = new FilteredLightManager();
        for (LightData light : lights) {
            LightSerializerRegistry.getLightSerializer(light.type).ifPresentOrElse(serializer -> serializer.deserializeLight(light.data).ifPresentOrElse(l -> mgr.lights.put(light.key, (IEntityBlockingLight)l), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}, deserialization failed, data is lost", (Object)light.key, (Object)light.type)), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}. Serializer not found, data is lost", (Object)light.key, (Object)light.type));
        }
        return mgr;
    }

    private List<LightData> save() {
        ArrayList<LightData> lightDataList = new ArrayList<LightData>();
        for (Map.Entry<String, IEntityBlockingLight> pair : this.lights.entrySet()) {
            String lightKey = pair.getKey();
            IEntityBlockingLight light = pair.getValue();
            String serializerType = light.getLightSerializerType();
            LightSerializerRegistry.getLightSerializer(serializerType).ifPresentOrElse(serializer -> {
                CompoundTag tag = serializer.serializeLight(light);
                LightData lightData = new LightData(lightKey, serializerType, tag);
                lightDataList.add(lightData);
            }, () -> Torchmaster.LOG.error("Unable to save light {}, data is lost", (Object)light.getPos()));
        }
        return lightDataList;
    }

    @Override
    public boolean shouldBlockEntityType(EntityType<?> entityType, Level level, Vec3 pos, EntitySpawnReason spawnType) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockEntityType(entityType, level, pos, spawnType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBlockVillageZombieRaid(Vec3 pos) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockVillageZombieRaid(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerLight(String lightKey, IEntityBlockingLight light) {
        this.lights.put(lightKey, light);
        this.setDirty();
    }

    @Override
    public void unregisterLight(String lightKey) {
        this.lights.remove(lightKey);
        this.setDirty();
    }

    @Override
    public Optional<IEntityBlockingLight> getLight(String lightKey) {
        IEntityBlockingLight light = this.lights.get(lightKey);
        if (light == null) {
            return Optional.empty();
        }
        return Optional.of(light);
    }

    @Override
    public void onGlobalTick(Level level) {
        for (IEntityBlockingLight light : this.lights.values()) {
            light.cleanupCheck(level);
        }
    }

    @Override
    public TorchInfo[] getEntries() {
        return new TorchInfo[0];
    }

    public static SavedDataType<FilteredLightManager> typeFor(String id) {
        return new SavedDataType("torchmaster_" + id, ctx -> new FilteredLightManager(), ctx -> CODEC, null);
    }

    record LightData(String key, String type, CompoundTag data) {
    }
}

