/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.event;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.Common;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;

public class DelayRender {
    public static Object2IntOpenHashMap<BlockEntity> cachedBE = new Object2IntOpenHashMap();

    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        if (!CCG.CONFIG.delayRender.renderAnalogBox) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            cachedBE.clear();
            return;
        }
        if (mc.m_91104_() || mc.f_91080_ != null) {
            return;
        }
        BlockEntity be = Common.getSelectedBE();
        if (be instanceof EncasedFanBlockEntity || be instanceof NozzleBlockEntity || be instanceof ArmBlockEntity || be instanceof EjectorBlockEntity) {
            cachedBE.put((Object)be, CCG.CONFIG.delayRender.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.object2IntEntrySet().removeIf(entry -> {
            BlockEntity blockEntity = (BlockEntity)entry.getKey();
            int newValue = entry.getIntValue() - 1;
            entry.setValue(newValue);
            if (!blockEntity.m_58901_()) {
                if (blockEntity instanceof EncasedFanBlockEntity) {
                    EncasedFanBlockEntity efbe = (EncasedFanBlockEntity)blockEntity;
                    DelayRender.render(efbe);
                } else if (blockEntity instanceof NozzleBlockEntity) {
                    NozzleBlockEntity nbe = (NozzleBlockEntity)blockEntity;
                    DelayRender.render(nbe);
                } else if (blockEntity instanceof ArmBlockEntity) {
                    ArmBlockEntity abe = (ArmBlockEntity)blockEntity;
                    DelayRender.render(abe);
                } else if (blockEntity instanceof EjectorBlockEntity) {
                    EjectorBlockEntity ebe = (EjectorBlockEntity)blockEntity;
                    DelayRender.render(ebe);
                }
            }
            return newValue <= 0;
        });
    }

    public static void render(@NotNull EncasedFanBlockEntity efbe) {
        AirCurrent airCurrent = efbe.airCurrent;
        int color = DelayRender.getColor(airCurrent.pushing);
        AABB bounds = airCurrent.bounds;
        CreateClient.OUTLINER.chaseAABB((Object)("FanAirBox" + String.valueOf(efbe)), bounds).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(airCurrent.maxDistance);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            double offsetDistance = (double)airCurrent.maxDistance * offset;
            Direction.Axis axis = airCurrent.direction.m_122434_();
            double min = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> bounds.f_82288_;
                case Direction.Axis.Y -> bounds.f_82289_;
                case Direction.Axis.Z -> bounds.f_82290_;
            };
            double max = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> bounds.f_82291_;
                case Direction.Axis.Y -> bounds.f_82292_;
                case Direction.Axis.Z -> bounds.f_82293_;
            };
            double pos = airCurrent.pushing == airCurrent.direction.m_122421_().m_122540_() > 0 ? min + offsetDistance : max - offsetDistance;
            AABB flowBound = switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> new AABB(pos, bounds.f_82289_, bounds.f_82290_, pos, bounds.f_82292_, bounds.f_82293_);
                case Direction.Axis.Y -> new AABB(bounds.f_82288_, pos, bounds.f_82290_, bounds.f_82291_, pos, bounds.f_82293_);
                case Direction.Axis.Z -> new AABB(bounds.f_82288_, bounds.f_82289_, pos, bounds.f_82291_, bounds.f_82292_, pos);
            };
            String id = "FanAirFlowBox" + String.valueOf(efbe) + i;
            if (offset > 0.98) {
                CreateClient.OUTLINER.remove((Object)id);
                continue;
            }
            CreateClient.OUTLINER.chaseAABB((Object)id, flowBound).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static void render(@NotNull NozzleBlockEntity nbe) {
        Vec3 center = VecHelper.getCenterOf((Vec3i)nbe.m_58899_());
        int color = DelayRender.getColor(nbe.pushing);
        CreateClient.OUTLINER.chaseAABB((Object)("NozzleAirBox" + String.valueOf(nbe)), new AABB(center, center).m_82400_((double)(nbe.range / 2.0f))).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = DelayRender.getNumberOfFlowBoxes(nbe.range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = DelayRender.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(nbe) + i;
            if (offset > 0.98) {
                CreateClient.OUTLINER.remove((Object)id);
                continue;
            }
            double radius = nbe.pushing ? offset * (double)nbe.range / 2.0 : (1.0 - offset) * (double)nbe.range / 2.0;
            AABB flowBound = new AABB(center, center).m_82400_(radius);
            CreateClient.OUTLINER.chaseAABB((Object)id, flowBound).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.delayRender.airBoxPushColor : CCG.CONFIG.delayRender.airBoxPullColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }

    public static void render(@NotNull ArmBlockEntity abe) {
        DelayRender.drawArmIO(abe, abe.inputs);
        DelayRender.drawArmIO(abe, abe.outputs);
    }

    public static void drawArmIO(@NotNull ArmBlockEntity abe, List<ArmInteractionPoint> list) {
        list.forEach(point -> {
            if (!point.isValid()) {
                return;
            }
            Level level = point.getLevel();
            BlockPos pos = point.getPos();
            CreateClient.OUTLINER.chaseAABB((Object)("ArmIOBox" + String.valueOf(point)), level.m_8055_(pos).m_60808_((BlockGetter)level, pos).m_83215_().m_82338_(pos)).withFaceTextures(AllSpecialTextures.HIGHLIGHT_CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(point.getMode().getColor());
            CreateClient.OUTLINER.showLine((Object)("ArmIOLine" + String.valueOf(point)), abe.m_58899_().m_252807_(), point.getPos().m_252807_()).lineWidth(0.125f).colored(point.getMode().getColor());
        });
    }

    public static void render(@NotNull EjectorBlockEntity ebe) {
        CreateClient.OUTLINER.chaseAABB((Object)("EjectorTargetBox" + String.valueOf(ebe)), new AABB(ebe.getTargetPosition())).lineWidth(0.0625f).colored(CCG.CONFIG.delayRender.airBoxPushColor);
    }
}

