/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.event;

import com.ForgeStove.create_cyber_goggles.Config;
import com.ForgeStove.create_cyber_goggles.event.KeyBinds;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterScreen;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.InputEvent;

public class KeyInputEvent {
    public static int index = 1;
    public static int scrollDeltaY = 0;

    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        HitResult hitResult;
        if (!((Boolean)Config.enhancedStoreRender.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockEntity blockEntity = mc.level.getBlockEntity(blockHitResult.getBlockPos());
        if (!(blockEntity instanceof TableClothBlockEntity)) {
            return;
        }
        event.setCanceled(true);
        scrollDeltaY = event.getScrollDeltaY() == 0.0 ? 0 : (event.getScrollDeltaY() > 0.0 ? -1 : 1);
    }

    public static void onKeyInput(InputEvent.Key event) {
        if (!((Boolean)Config.enableOpenFilterScreen.get()).booleanValue()) {
            return;
        }
        if (!KeyBinds.isKeyDown(event, KeyBinds.PREVIEW_FILTER)) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            Screen screen = mc.screen;
            if (!(screen instanceof AbstractContainerScreen)) {
                return;
            }
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            Slot slot = screen2.getSlotUnderMouse();
            if (slot == null) {
                return;
            }
            KeyInputEvent.setFilterScreen(slot.getItem());
        } else {
            HitResult slot;
            if (mc.level == null || !((slot = mc.hitResult) instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockHitResult = (BlockHitResult)slot;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockEntity blockEntity = mc.level.getBlockEntity(blockHitResult.getBlockPos());
            if (!(blockEntity instanceof SmartBlockEntity)) {
                return;
            }
            SmartBlockEntity smartBlockEntity = (SmartBlockEntity)blockEntity;
            Set<BlockEntityBehaviour> behavior = Collections.singleton(smartBlockEntity.getBehaviour(FilteringBehaviour.TYPE));
            BlockEntityBehaviour first = (BlockEntityBehaviour)behavior.iterator().next();
            if (!(first instanceof FilteringBehaviour)) {
                return;
            }
            FilteringBehaviour filteringBehaviour = (FilteringBehaviour)first;
            KeyInputEvent.setFilterScreen(filteringBehaviour.getFilter(blockHitResult.getDirection()));
        }
    }

    public static void setFilterScreen(ItemStack filter) {
        if (filter.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        Inventory inventory = player.getInventory();
        switch (filter.getDescriptionId()) {
            case "item.create.filter": {
                mc.setScreen((Screen)new FilterScreen(FilterMenu.create((int)-1, (Inventory)inventory, (ItemStack)filter), inventory, filter.getHoverName()));
                break;
            }
            case "item.create.attribute_filter": {
                mc.setScreen((Screen)new AttributeFilterScreen(AttributeFilterMenu.create((int)-1, (Inventory)inventory, (ItemStack)filter), inventory, filter.getHoverName()));
                break;
            }
            case "item.create.package_filter": {
                mc.setScreen((Screen)new PackageFilterScreen(PackageFilterMenu.create((int)-1, (Inventory)inventory, (ItemStack)filter), inventory, filter.getHoverName()));
            }
        }
    }
}

