/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGLang;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BacktankBlockEntity.class}, remap=false)
public abstract class BacktankBlockEntityMixin
extends KineticBlockEntity
implements IHaveGoggleInformation {
    @Unique
    public int ccg$leftTick;
    @Unique
    public int ccg$prevAirLevel;
    @Shadow
    public int airLevel;
    @Shadow
    public int airLevelTimer;
    @Shadow
    private int capacityEnchantLevel;

    public BacktankBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        int totalBars = 20;
        int max = BacktankUtil.maxAir((int)this.capacityEnchantLevel);
        float percent = (float)this.airLevel / (float)max;
        int filledBars = (int)(percent * (float)totalBars);
        CCGLang.translate("tooltip.airLevel", new Object[0]).forGoggles(tooltip);
        CCGLang.text(Color.HSBtoRGB(percent * 0.33f, 1.0f, 1.0f), "%d/%d".formatted(max, this.airLevel)).forGoggles(tooltip);
        CCGLang.text(ChatFormatting.GREEN, "|".repeat(filledBars)).add(CCGLang.text("|".repeat(totalBars - filledBars)).style(ChatFormatting.GRAY)).forGoggles(tooltip);
        if (this.getSpeed() == 0.0f || this.ccg$leftTick == 0) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        CCGLang.translate("tooltip.leftTime", new Object[0]).add(CCGLang.text(ChatFormatting.AQUA, " %.2f ".formatted(Float.valueOf((float)this.ccg$leftTick / 20.0f)))).translate("tooltip.seconds", new Object[0]).forGoggles(tooltip);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN", ordinal=3)})
    public void tick(CallbackInfo callbackInfo, @Local(name={"max"}) int max) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        if (this.airLevel == max) {
            return;
        }
        this.ccg$prevAirLevel = this.airLevel;
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.m_14045_((int)(((int)abs - 100) / 20), (int)1, (int)5);
        this.airLevel = Math.min(max, this.airLevel + increment);
        this.airLevelTimer = Mth.m_14045_((int)((int)(128.0f - abs / 5.0f) - 108), (int)0, (int)20);
        this.ccg$leftTick = (max - this.airLevel) / increment * Math.max(1, this.airLevelTimer);
    }

    @ModifyVariable(method={"read"}, at=@At(value="STORE"), name={"prev"})
    private int modifyPrev(int prev) {
        return this.ccg$prevAirLevel;
    }
}

