/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllMenuTypes;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreen;
import com.simibubi.create.content.logistics.filter.PackageFilterMenu;
import com.simibubi.create.content.logistics.filter.PackageFilterScreen;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestScreen;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.CCGConfig;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.TableClothUtil;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.InputEvent;

public class KeyInput {
    public static StockTickerBlockEntity lastSTBE;
    public static int scrollDeltaY;

    public static void key(InputEvent.Key ignoredEvent) {
        KeyInput.toggleGoggle();
        KeyInput.toggleDiving();
        KeyInput.openConfigScreen();
        KeyInput.openStockScreen();
        KeyInput.previewFilterScreen();
    }

    public static void mouseScroll(InputEvent.MouseScrollingEvent event) {
        KeyInput.clothStore(event);
    }

    private static void toggleGoggle() {
        CCGUtil.toggleConfig(CCGKey.toggleGoggle.isDown(), CCG.CONFIG.gameMode.enableGoggles, val -> {
            CCG.CONFIG.gameMode.enableGoggles = val;
        }, "message.goggle");
    }

    private static void toggleDiving() {
        CCGUtil.toggleConfig(CCGKey.toggleDiving.isDown(), CCG.CONFIG.misc.allowDivingBoot, val -> {
            CCG.CONFIG.misc.allowDivingBoot = val;
        }, "message.divingBoot");
    }

    private static void openConfigScreen() {
        if (!CCGKey.openConfig.isDown()) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        CCGUtil.mc.setScreen((Screen)AutoConfig.getConfigScreen(CCGConfig.class, null).get());
    }

    private static void openStockScreen() {
        if (!CCGKey.openStock.isDown()) {
            return;
        }
        if (CCGUtil.isInGUI()) {
            return;
        }
        if (CCGUtil.mc.player == null) {
            return;
        }
        StockTickerBlockEntity stbe = CCGUtil.getBlockEntity(StockTickerBlockEntity.class);
        if (stbe != null) {
            lastSTBE = stbe;
        }
        if (lastSTBE == null || lastSTBE.isRemoved()) {
            CCGLang.translate("message.notStock", new Object[0]).text("  ").translate("key.openStock", new Object[0]).style(ChatFormatting.RED).sendStatus((Player)CCGUtil.mc.player);
            return;
        }
        Inventory inv = CCGUtil.mc.player.getInventory();
        StockKeeperRequestMenu menu = new StockKeeperRequestMenu((MenuType)AllMenuTypes.STOCK_KEEPER_REQUEST.get(), -1, inv, lastSTBE);
        CCGUtil.mc.setScreen((Screen)new StockKeeperRequestScreen(menu, inv, (Component)lastSTBE.getBlockState().getBlock().getName()));
    }

    private static void previewFilterScreen() {
        if (!CCGKey.previewFilter.isDown()) {
            return;
        }
        if (CCGUtil.mc.player == null) {
            return;
        }
        ItemStack itemStack = CCGUtil.getSelectedFilter();
        if (itemStack == null || !(itemStack.getItem() instanceof FilterItem)) {
            return;
        }
        CCGUtil.mc.setScreen((Screen)Map.of((Item)AllItems.FILTER.get(), (id, inv, stack) -> new FilterScreen(FilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName()), (Item)AllItems.ATTRIBUTE_FILTER.get(), (id, inv, stack) -> new AttributeFilterScreen(AttributeFilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName()), (Item)AllItems.PACKAGE_FILTER.get(), (id, inv, stack) -> new PackageFilterScreen(PackageFilterMenu.create((int)id, (Inventory)inv, (ItemStack)stack), inv, stack.getHoverName())).get(itemStack.getItem()).apply((Object)-1, (Object)CCGUtil.mc.player.getInventory(), (Object)itemStack));
        CCGUtil.playSound(SoundEvents.BOOK_PAGE_TURN, 1.0f, 1.0f);
    }

    private static void clothStore(InputEvent.MouseScrollingEvent event) {
        if (!CCG.CONFIG.goggles.betterStoreInfo) {
            return;
        }
        if (!CCGKey.toggleItemOverlay.isDown()) {
            return;
        }
        TableClothBlockEntity tcbe = CCGUtil.getBlockEntity(TableClothBlockEntity.class);
        if (tcbe == null) {
            return;
        }
        if (TableClothUtil.getItems(tcbe).size() <= 1) {
            return;
        }
        if (CCGUtil.hasActivedValueBox()) {
            return;
        }
        scrollDeltaY = (int)event.getScrollDeltaY();
        event.setCanceled(true);
    }
}

