/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.Self;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlazeBurnerBlockEntity.class})
public abstract class BlazeBurnerBlockEntityMixin
implements IHaveGoggleInformation,
Self<BlazeBurnerBlockEntity> {
    @Shadow
    public boolean isCreative;
    @Shadow
    protected int remainingBurnTime;
    @Shadow
    protected BlazeBurnerBlockEntity.FuelType activeFuel;

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TooltipUtil.burner(tooltip, this.remainingBurnTime, this.isCreative, this.activeFuel);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        Level level = ((BlazeBurnerBlockEntity)this.self()).getLevel();
        if (level == null || !level.isClientSide) {
            return;
        }
        if (this.isCreative) {
            return;
        }
        if (this.remainingBurnTime > 0) {
            --this.remainingBurnTime;
        }
    }
}

