/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IOutlineRenderable;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Outliner {
    public static final Map<BlockEntity, Integer> cachedBE = new Object2IntOpenHashMap();

    public static void tick(TickEvent.ClientTickEvent ignoredEvent) {
        if (!CCG.CONFIG.outliner.renderAnalogBox) {
            return;
        }
        if (CCGUtil.mc.m_91104_() || CCGUtil.isInGUI()) {
            return;
        }
        BlockEntity be = CCGUtil.getBlockEntity();
        if (be instanceof IOutlineRenderable) {
            cachedBE.put(be, CCG.CONFIG.outliner.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.entrySet().removeIf(Outliner::render);
    }

    private static boolean render(@NotNull Map.Entry<BlockEntity, Integer> entry) {
        int nextDelay = entry.getValue() - 1;
        entry.setValue(nextDelay);
        BlockEntity be = entry.getKey();
        if (!be.m_58901_() && be instanceof IOutlineRenderable) {
            IOutlineRenderable ior = (IOutlineRenderable)be;
            ior.ccg$render();
        }
        return nextDelay <= 0;
    }

    @Contract(pure=true)
    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.outliner.outColor : CCG.CONFIG.outliner.inColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    @Contract(pure=true)
    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }
}

