/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.event.Outliner;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class TooltipUtil {
    public static void kinetic(List<Component> tooltip, @NotNull KineticBlockEntity kbe, float stress, float capacity) {
        float stressAtBase;
        float speed = kbe.getTheoreticalSpeed();
        if (IRotate.StressImpact.isEnabled() && !Mth.m_14033_((float)(stressAtBase = kbe.calculateStressApplied()), (float)0.0f)) {
            CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.number((double)(stressAtBase * Math.abs(speed))).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        CreateLang.translate((String)"gui.speedometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        IRotate.SpeedLevel.getFormattedSpeedText((float)speed, (boolean)kbe.isOverStressed()).forGoggles(tooltip);
        if (!CCGKey.showStress.isDown()) {
            return;
        }
        double stressFraction = stress / (capacity == 0.0f ? 1.0f : capacity);
        CreateLang.translate((String)"gui.stressometer.title", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        if (speed == 0.0f) {
            CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)0)).translate("gui.stressometer.no_rotation", new Object[0]).style(ChatFormatting.DARK_GRAY).forGoggles(tooltip);
        } else {
            IRotate.StressImpact.getFormattedStressText((double)stressFraction).forGoggles(tooltip);
            CreateLang.translate((String)"gui.stressometer.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            double remainingCapacity = capacity - stress;
            LangBuilder su = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
            LangBuilder stressTip = CreateLang.number((double)remainingCapacity).add(su).style(IRotate.StressImpact.of((double)stressFraction).getRelativeColor());
            if (remainingCapacity != (double)capacity) {
                stressTip.text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)capacity).add(su).style(ChatFormatting.DARK_GRAY));
            }
            stressTip.forGoggles(tooltip, 1);
        }
    }

    public static void generatingKinetic(List<Component> tooltip, @NotNull GeneratingKineticBlockEntity gkbe) {
        float stressBase = gkbe.calculateAddedStressCapacity();
        if (!Mth.m_14033_((float)stressBase, (float)0.0f)) {
            CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float speed = gkbe.getTheoreticalSpeed();
            float generatedSpeed = gkbe.getGeneratedSpeed();
            if (speed != generatedSpeed) {
                stressBase *= generatedSpeed / speed;
            }
            CreateLang.number((double)Math.abs(stressBase * speed)).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
    }

    public static boolean fan(List<Component> tooltip, boolean pushing, float range, int divide) {
        if (range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range / (float)divide).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(Outliner.getColor(pushing)).forGoggles(tooltip);
        return true;
    }

    public static boolean burner(List<Component> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        if (remainingBurnTime == 0 && !isCreative) {
            return false;
        }
        ChatFormatting format = switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> ChatFormatting.AQUA;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> ChatFormatting.GOLD;
            default -> ChatFormatting.DARK_PURPLE;
        };
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        CCGLang.translate(ChatFormatting.GRAY, "tooltip.leftTime", new Object[0]).add(CCGLang.text(format, isCreative ? "\u221e" : String.valueOf(remainingBurnTime / 20))).add(CCGLang.text(" / %d ".formatted(500))).add(CCGLang.seconds()).forGoggles(tooltip);
        return true;
    }

    public static void cannon(List<Component> tooltip, @NotNull SchematicannonBlockEntity sbe) {
        CCGLang.translate("tooltip.cannonState", new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)("schematicannon.status." + sbe.statusMsg), (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        int shotsLeft = sbe.remainingFuel;
        int shotsLeftWithItems = shotsLeft + sbe.inventory.getStackInSlot(4).m_41613_() * sbe.getShotsPerGunpowder();
        if (sbe.hasCreativeCrate) {
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{"100"}).forGoggles(tooltip);
            CCGLang.text("(").add(((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).m_49954_()).text(")").style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
        } else {
            int fillPercent = (int)((float)shotsLeft / (float)sbe.getShotsPerGunpowder() * 100.0f);
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{fillPercent}).forGoggles(tooltip);
            CreateLang.translate((String)"gui.schematicannon.shotsRemaining", (Object[])new Object[]{CCGLang.number(ChatFormatting.BLUE, shotsLeft)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            if (shotsLeftWithItems != shotsLeft) {
                CreateLang.translate((String)"gui.schematicannon.shotsRemainingWithBackup", (Object[])new Object[]{CCGLang.number(ChatFormatting.BLUE, shotsLeftWithItems)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            }
        }
        if (!sbe.state.equals((Object)SchematicannonBlockEntity.State.RUNNING)) {
            return;
        }
        CCGLang.translate("tooltip.printProgress", new Object[0]).forGoggles(tooltip);
        CCGLang.fraction(sbe.blocksPlaced, sbe.blocksToPlace).forGoggles(tooltip);
        CCGLang.progress(sbe.schematicProgress, 20).forGoggles(tooltip);
    }

    public static void backtank(List<Component> tooltip, BacktankBlockEntity bbe, int capacityEnchantLevel, int leftTick) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.fraction(bbe.airLevel, BacktankUtil.maxAir((int)capacityEnchantLevel))).forGoggles(tooltip);
        if (bbe.getSpeed() == 0.0f || leftTick == 0) {
            return;
        }
        CCGLang.translate("tooltip.leftTime", new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.number(ChatFormatting.GOLD, leftTick / 20)).space().add(CCGLang.seconds().style(ChatFormatting.GRAY)).forGoggles(tooltip);
    }

    public static void beltThroughput(List<Component> tooltip, double itemsPerSecond) {
        if (itemsPerSecond < 0.1) {
            return;
        }
        CCGLang.translate("tooltip.beltThroughput", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CCGLang.text(String.format("%.2f", itemsPerSecond)).style(ChatFormatting.GOLD).add(CCGLang.text(" / ").style(ChatFormatting.DARK_GRAY).add(CCGLang.seconds().style(ChatFormatting.DARK_GRAY))).forGoggles(tooltip, 1);
    }
}

