/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.render;

import com.ForgeStove.create_cyber_goggles.Config;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;

public class OverlayRenderer {
    public static final LayeredDraw.Layer OVERLAY = OverlayRenderer::renderOverlay;

    public static void register(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"create_cyber_goggles", (String)"overlay"), OVERLAY);
    }

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        ItemStack itemStack;
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.hasContainerOpen() || mc.isPaused()) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockHitResult.getBlockPos());
        if (((Boolean)Config.renderExtraItems.get()).booleanValue() && blockEntity instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)blockEntity;
            itemStack = depotBlockEntity.getHeldItem();
        } else if (((Boolean)Config.renderExtraItems.get()).booleanValue() && blockEntity instanceof PackagerBlockEntity) {
            PackagerBlockEntity packagerBlockEntity = (PackagerBlockEntity)blockEntity;
            itemStack = packagerBlockEntity.heldBox;
        } else {
            if (((Boolean)Config.enableKineticEffect.get()).booleanValue() && blockEntity instanceof KineticBlockEntity) {
                KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
                if (blockHitResult.getType() == HitResult.Type.MISS) {
                    return;
                }
                if (!blockHitResult.getBlockPos().equals((Object)kineticBlockEntity.getBlockPos())) {
                    return;
                }
                float speed = kineticBlockEntity.getSpeed();
                if (speed == 0.0f) {
                    return;
                }
                BlockState state = kineticBlockEntity.getBlockState();
                Block block = state.getBlock();
                if (!(block instanceof KineticBlock)) {
                    return;
                }
                KineticBlock kineticBlock = (KineticBlock)block;
                Direction.Axis rotationAxis = kineticBlock.getRotationAxis(state);
                if (rotationAxis == null) {
                    return;
                }
                Vec3 center = VecHelper.getCenterOf((Vec3i)kineticBlockEntity.getBlockPos());
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)speed);
                int particleSpeed = Math.max(15, speedLevel.getParticleSpeed());
                float v = (float)particleSpeed * Math.signum(speed);
                level.addParticle((ParticleOptions)new RotationIndicatorParticleData(speedLevel.getColor(), v, kineticBlock.getParticleInitialRadius(), kineticBlock.getParticleTargetRadius(), 10, rotationAxis), center.x, center.y, center.z, 0.0, 0.0, 0.0);
                return;
            }
            return;
        }
        OverlayRenderer.renderItemStack(guiGraphics, itemStack);
    }

    public static void renderItemStack(GuiGraphics guiGraphics, ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        TooltipFlag.Default tooltipFlag = mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int tooltipHeight = n * 9;
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight() / 2;
        guiGraphics.renderItem(itemStack, x + 10, y - 15);
        guiGraphics.renderItemDecorations(font, itemStack, x + 10, y - 15);
        guiGraphics.renderComponentTooltip(font, tooltipLines, x + 22, y - Math.max(10, tooltipHeight - 70));
    }
}

