/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.Render;

import com.simibubi.create.content.logistics.depot.DepotBlock;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class OverlayRenderer {
    public static final LayeredDraw.Layer OVERLAY = OverlayRenderer::renderOverlay;

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && player.hasContainerOpen() || mc.isPaused()) {
            return;
        }
        ItemStack itemStack = ItemStack.EMPTY;
        ClientLevel level = mc.level;
        if (level != null && (hitResult = mc.hitResult) instanceof BlockHitResult) {
            DepotBlock depotBlock;
            DepotBlockEntity blockEntity;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.getBlockPos();
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            Block block = level.getBlockState(blockPos).getBlock();
            if (block instanceof DepotBlock && (blockEntity = (DepotBlockEntity)(depotBlock = (DepotBlock)block).getBlockEntity((BlockGetter)level, blockPos)) != null) {
                itemStack = blockEntity.getHeldItem();
            }
        }
        if (itemStack.isEmpty()) {
            return;
        }
        Font font = mc.font;
        TooltipFlag.Default tooltipFlag = mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        List tooltipLines = itemStack.getTooltipLines(Item.TooltipContext.of((Level)level), (Player)player, (TooltipFlag)tooltipFlag);
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int tooltipHeight = n * 9 + 8;
        int x = guiGraphics.guiWidth() / 2;
        int y = guiGraphics.guiHeight() / 2;
        guiGraphics.renderItem(itemStack, x + 10, y - 15);
        guiGraphics.renderItemDecorations(font, itemStack, x + 10, y - 15);
        guiGraphics.renderComponentTooltip(font, tooltipLines, x + 20, y - Math.max(0, tooltipHeight - 75));
    }
}

