/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.mixin.ChainConveyor;

import com.ForgeStove.create_cyber_goggles.Config;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlock;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionHandler;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorConnectionPacket;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChainConveyorConnectionHandler.class})
public abstract class ChainConveyorConnectionHandlerMixin {
    @Shadow
    private static BlockPos firstPos;
    @Shadow
    private static ResourceKey<Level> firstDim;

    @Inject(method={"validateAndConnect"}, at={@At(value="HEAD")}, cancellable=true)
    private static void validateAndConnect(LevelAccessor level, BlockPos pos, Player player, ItemStack chain, boolean simulate, CallbackInfoReturnable<Boolean> returnable) {
        if (!((Boolean)Config.EnhancedChainConnection.get()).booleanValue()) {
            return;
        }
        returnable.setReturnValue((Object)false);
        if (!simulate && player.isShiftKeyDown()) {
            CreateLang.translate((String)"chain_conveyor.selection_cleared", (Object[])new Object[0]).sendStatus(player);
            return;
        }
        if (pos.equals((Object)firstPos)) {
            return;
        }
        if (!pos.closerThan((Vec3i)firstPos, (double)((Integer)AllConfigs.server().kinetics.maxChainConveyorLength.get()).intValue())) {
            CreateLang.translate((String)"chain_conveyor.too_far", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        ChainConveyorBlock chainConveyorBlock = (ChainConveyorBlock)AllBlocks.CHAIN_CONVEYOR.get();
        ChainConveyorBlockEntity sourceLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((BlockGetter)level, firstPos);
        ChainConveyorBlockEntity targetLift = (ChainConveyorBlockEntity)chainConveyorBlock.getBlockEntity((BlockGetter)level, pos);
        if (sourceLift == null || targetLift == null) {
            CreateLang.translate((String)"chain_conveyor.blocks_invalid", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        if (targetLift.connections.size() >= (Integer)AllConfigs.server().kinetics.maxChainConveyorConnections.get()) {
            CreateLang.translate((String)"chain_conveyor.cannot_add_more_connections", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        if (targetLift.connections.contains(firstPos.subtract((Vec3i)pos))) {
            CreateLang.translate((String)"chain_conveyor.already_connected", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        if (!player.isCreative()) {
            int chainCost = ChainConveyorBlockEntity.getChainCost((BlockPos)pos.subtract((Vec3i)firstPos));
            boolean hasEnough = ChainConveyorBlockEntity.getChainsFromInventory((Player)player, (ItemStack)chain, (int)chainCost, (boolean)true);
            if (simulate) {
                BlueprintOverlayRenderer.displayChainRequirements((Item)chain.getItem(), (int)chainCost, (boolean)hasEnough);
            }
            if (!hasEnough) {
                CreateLang.translate((String)"chain_conveyor.not_enough_chains", (Object[])new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
        }
        returnable.setReturnValue((Object)true);
        if (simulate) {
            return;
        }
        player.swing(player.getUsedItemHand());
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ChainConveyorConnectionPacket(firstPos, pos, chain, true));
        CreateLang.text((String)"").sendStatus(player);
        firstPos = null;
        firstDim = null;
    }
}

