/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.mixin.Goggles;

import com.ForgeStove.create_cyber_goggles.Config;
import com.ForgeStove.create_cyber_goggles.Event.KeyInputEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.simibubi.create.content.logistics.tableCloth.BlueprintOverlayShopContext;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlueprintOverlayRenderer.class})
public abstract class BlueprintOverlayRendererMixin {
    @Shadow
    static boolean active;
    @Shadow
    static boolean empty;
    @Shadow
    static List<Pair<ItemStack, Boolean>> ingredients;
    @Shadow
    static List<ItemStack> results;
    @Shadow
    static boolean noOutput;
    @Shadow
    static boolean resultCraftable;
    @Shadow
    static BlueprintOverlayShopContext shopContext;
    @Unique
    private static int createCyberGoggles$index;

    @Inject(method={"renderOverlay"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo callbackInfo) {
        if (!((Boolean)Config.EnhancedGogglesInfo.get()).booleanValue()) {
            return;
        }
        callbackInfo.cancel();
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.screen != null) {
            return;
        }
        if (!active || empty) {
            return;
        }
        boolean invalidShop = shopContext != null && (ingredients.isEmpty() || ((ItemStack)ingredients.getFirst().getFirst()).isEmpty() || shopContext.stockLevel() == 0);
        int w = 21 * ingredients.size();
        if (!noOutput) {
            w += 21 * results.size();
            w += 30;
        }
        int x = (guiGraphics.guiWidth() - w) / 2;
        int y = guiGraphics.guiHeight() - 100;
        if (shopContext != null) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(x - 2), (int)(y + 1), (int)(w + 4), (int)19, (int)0, (int)0x55000000, (int)0x55000000, (int)0, (int)0);
            AllGuiTextures.TRADE_OVERLAY.render(guiGraphics, guiGraphics.guiWidth() / 2 - 48, y - 19);
            if (shopContext.purchases() > 0) {
                guiGraphics.renderItem(AllItems.SHOPPING_LIST.asStack(), guiGraphics.guiWidth() / 2 + 20, y - 20);
                guiGraphics.drawString(mc.font, (Component)Component.literal((String)("x" + shopContext.purchases())), guiGraphics.guiWidth() / 2 + 20 + 16, y - 20 + 4, -1118482, true);
            }
        }
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.enableBlend();
            ((Boolean)pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(guiGraphics, x, y);
            ItemStack itemStack = (ItemStack)pair.getFirst();
            String count = shopContext != null && !shopContext.checkout() || (Boolean)pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.getCount();
            BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)itemStack, (String)count);
            x += 21;
        }
        if (noOutput) {
            return;
        }
        x += 5;
        RenderSystem.enableBlend();
        if (invalidShop) {
            AllGuiTextures.HOTSLOT_ARROW_BAD.render(guiGraphics, x, y + 4);
        } else {
            AllGuiTextures.HOTSLOT_ARROW.render(guiGraphics, x, y + 4);
        }
        x += 25;
        if (results.isEmpty()) {
            AllGuiTextures.HOTSLOT.render(guiGraphics, x, y);
            GuiGameElement.of((ItemLike)Items.BARRIER).at((float)(x + 3), (float)(y + 3)).render(guiGraphics);
        } else {
            for (ItemStack result : results) {
                AllGuiTextures slot;
                AllGuiTextures allGuiTextures = slot = resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT;
                if (!invalidShop && shopContext != null && shopContext.stockLevel() > shopContext.purchases()) {
                    slot = AllGuiTextures.HOTSLOT_ACTIVE;
                }
                slot.render(guiGraphics, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
                BlueprintOverlayRenderer.drawItemStack((GuiGraphics)guiGraphics, (Minecraft)mc, (int)x, (int)y, (ItemStack)result, null);
                x += 21;
            }
        }
        if (shopContext == null || shopContext.checkout()) {
            RenderSystem.disableBlend();
            return;
        }
        if ((createCyberGoggles$index += KeyInputEvent.scrollKeyboard) < 1) {
            createCyberGoggles$index = results.size();
        } else if (createCyberGoggles$index > results.size()) {
            createCyberGoggles$index = 1;
        }
        KeyInputEvent.scrollKeyboard = 0;
        ItemStack result = results.get(createCyberGoggles$index - 1);
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        TooltipFlag.Default tooltipFlag = mc.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL;
        List tooltipLines = result.getTooltipLines(Item.TooltipContext.of((Level)level), (Player)player, (TooltipFlag)tooltipFlag);
        Font font = mc.font;
        int n = tooltipLines.size();
        Objects.requireNonNull(font);
        int tooltipHeight = n * 9 + 8;
        int width = guiGraphics.guiWidth() / 2;
        int height = guiGraphics.guiHeight() / 2;
        guiGraphics.renderItem(result, width + 10, height - 15);
        guiGraphics.renderItemDecorations(font, result, width + 10, height - 15);
        int mouseY = Math.max(0, height - Math.max(0, tooltipHeight - 80));
        guiGraphics.renderComponentTooltip(font, tooltipLines, width + 20, mouseY);
        RenderSystem.disableBlend();
    }

    static {
        createCyberGoggles$index = 1;
    }
}

