/*
 * Decompiled with CFR 0.152.
 */
package com.ForgeStove.create_cyber_goggles.mixin.Goggles;

import com.ForgeStove.create_cyber_goggles.Config;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GeneratingKineticBlockEntity.class})
public abstract class GeneratingKineticBlockEntityMixin
extends KineticBlockEntity {
    public GeneratingKineticBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Inject(method={"addToGoggleTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, CallbackInfoReturnable<Boolean> returnable) {
        if (!((Boolean)Config.EnhancedGogglesInfo.get()).booleanValue()) {
            return;
        }
        returnable.setReturnValue((Object)true);
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip, 0);
        float stressBase = this.calculateAddedStressCapacity();
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 0);
        float speed = this.getTheoreticalSpeed();
        if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
            stressBase *= this.getGeneratedSpeed() / speed;
        }
        float stressTotal = Math.abs(stressBase * speed);
        CreateLang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 0);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

