/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EntityLauncher;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IItemRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.IOutlineRenderable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={EjectorBlockEntity.class}, remap=false)
public abstract class EjectorBlockEntityMixin
extends KineticBlockEntity
implements IItemRenderable,
IOutlineRenderable {
    @Unique
    public EntityLauncher ccg$launcher;
    @Shadow
    DepotBehaviour depotBehaviour;

    public EjectorBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Shadow
    public abstract BlockPos getTargetPosition();

    @Shadow
    protected abstract Direction getFacing();

    @Shadow
    protected abstract boolean cannotLaunch();

    @Override
    public ItemStack ccg$getItemStack() {
        return this.depotBehaviour.getHeldItemStack();
    }

    @Override
    public void ccg$render() {
        BlockPos targetPos = this.getTargetPosition();
        CCGUtil.outliner.showAABB((Object)("EjectorTargetBox" + String.valueOf(this)), CCGUtil.getBounds(targetPos)).lineWidth(0.0625f).colored(CCG.CONFIG.outlineRenderer.windPushColor);
        int color = this.cannotLaunch() ? 0xFF7171 : 10411635;
        CCGUtil.outliner.showAABB((Object)("EjectorFromBox" + String.valueOf(this)), new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).m_82338_(this.f_58858_)).lineWidth(0.0625f).colored(color);
        int xDiff = targetPos.m_123341_() - this.f_58858_.m_123341_();
        int yDiff = targetPos.m_123342_() - this.f_58858_.m_123342_();
        int zDiff = targetPos.m_123343_() - this.f_58858_.m_123343_();
        if (this.ccg$launcher == null) {
            this.ccg$launcher = new EntityLauncher(Math.abs(xDiff + zDiff), yDiff);
        }
        double totalFlyingTicks = this.ccg$launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)totalFlyingTicks / 3 + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        DustParticleOptions data = new DustParticleOptions(new Color(color).asVectorF(), 1.0f);
        if (CCGUtil.mc.f_91073_ == null) {
            return;
        }
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = this.ccg$launcher.getGlobalPos(ticks, this.getFacing().m_122424_(), this.f_58858_);
            CCGUtil.mc.f_91073_.m_7106_((ParticleOptions)data, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

