/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class KineticParticle {
    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (!CCG.CONFIG.goggles.enableKineticEffect) {
            return;
        }
        if (CCGUtil.mc.level == null || CCGUtil.isInGUI()) {
            return;
        }
        KineticBlockEntity kbe = CCGUtil.getBlockEntity(KineticBlockEntity.class);
        if (kbe == null) {
            return;
        }
        float speed = kbe.getSpeed();
        if (speed == 0.0f) {
            return;
        }
        BlockState state = kbe.getBlockState();
        Block block = state.getBlock();
        if (!(block instanceof KineticBlock)) {
            return;
        }
        KineticBlock kb = (KineticBlock)block;
        Direction.Axis axis = kb.getRotationAxis(state);
        if (axis == null) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)kbe.getBlockPos());
        IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of((float)speed);
        RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(speedLevel.getColor(), (float)Math.max(15, speedLevel.getParticleSpeed()) * Math.signum(speed), kb.getParticleInitialRadius() / 2.0f, kb.getParticleTargetRadius() / 2.0f, 10, axis);
        double offset = 0.5;
        Vec3 axisVec = new Vec3(axis == Direction.Axis.X ? offset : 0.0, axis == Direction.Axis.Y ? offset : 0.0, axis == Direction.Axis.Z ? offset : 0.0);
        for (int i = -1; i <= 1; i += 2) {
            Vec3 pos = center.add(axisVec.scale((double)i));
            for (int j = 0; j < 3; ++j) {
                CCGUtil.mc.level.addParticle((ParticleOptions)particleData, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }
}

