/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.util;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TooltipUtil {
    public static boolean addFanTooltip(List<Component> tooltip, boolean pushing, float range, int divide) {
        if (range == 0.0f) {
            return false;
        }
        CCGLang.translate("tooltip.windState", new Object[0]).forGoggles(tooltip);
        CCGLang.number(range / (float)divide).space().translate(pushing ? "tooltip.pushRange" : "tooltip.pullRange", new Object[0]).color(pushing ? CCG.CONFIG.outlineRenderer.windPushColor : CCG.CONFIG.outlineRenderer.windPullColor).forGoggles(tooltip);
        return true;
    }

    public static boolean addBurnerTooltip(List<Component> tooltip, int remainingBurnTime, boolean isCreative, BlazeBurnerBlockEntity.FuelType activeFuel) {
        if (remainingBurnTime == 0 && !isCreative) {
            return false;
        }
        ChatFormatting format = switch (activeFuel) {
            case BlazeBurnerBlockEntity.FuelType.SPECIAL -> ChatFormatting.AQUA;
            case BlazeBurnerBlockEntity.FuelType.NORMAL -> ChatFormatting.GOLD;
            default -> ChatFormatting.DARK_PURPLE;
        };
        CCGLang.translate("tooltip.burnerState", new Object[0]).forGoggles(tooltip);
        CCGLang.translate(ChatFormatting.GRAY, "tooltip.leftTime", new Object[0]).add(CCGLang.text(format, isCreative ? "\u221e" : String.valueOf(remainingBurnTime / 20))).add(CCGLang.text(" / %d ".formatted(500))).add(CCGLang.seconds()).forGoggles(tooltip);
        return true;
    }

    public static void addCannonTooltip(List<Component> tooltip, @NotNull SchematicannonBlockEntity sbe) {
        CCGLang.translate("tooltip.cannonState", new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)("schematicannon.status." + sbe.statusMsg), (Object[])new Object[0]).style(ChatFormatting.GOLD).forGoggles(tooltip);
        int shotsLeft = sbe.remainingFuel;
        int shotsLeftWithItems = shotsLeft + sbe.inventory.getStackInSlot(4).getCount() * sbe.getShotsPerGunpowder();
        if (sbe.hasCreativeCrate) {
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{"100"}).forGoggles(tooltip);
            CCGLang.text(ChatFormatting.DARK_PURPLE, "(" + String.valueOf(((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).getName()) + ")").forGoggles(tooltip);
        } else {
            int fillPercent = (int)((float)shotsLeft / (float)sbe.getShotsPerGunpowder() * 100.0f);
            CreateLang.translate((String)"gui.schematicannon.gunpowderLevel", (Object[])new Object[]{fillPercent}).forGoggles(tooltip);
            CreateLang.translate((String)"gui.schematicannon.shotsRemaining", (Object[])new Object[]{CCGLang.number(ChatFormatting.BLUE, shotsLeft)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            if (shotsLeftWithItems != shotsLeft) {
                CreateLang.translate((String)"gui.schematicannon.shotsRemainingWithBackup", (Object[])new Object[]{CCGLang.number(ChatFormatting.BLUE, shotsLeftWithItems)}).style(ChatFormatting.GRAY).forGoggles(tooltip);
            }
        }
        if (!sbe.state.equals((Object)SchematicannonBlockEntity.State.RUNNING)) {
            return;
        }
        CCGLang.translate("tooltip.printProgress", new Object[0]).forGoggles(tooltip);
        CCGLang.fraction(sbe.blocksPlaced, sbe.blocksToPlace).forGoggles(tooltip);
        CCGLang.progress(sbe.schematicProgress, 20).forGoggles(tooltip);
    }

    public static void addBacktankTooltip(List<Component> tooltip, BacktankBlockEntity bbe, int capacityEnchantLevel, int leftTick) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        CreateLang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.fraction(bbe.airLevel, BacktankUtil.maxAir((int)capacityEnchantLevel))).forGoggles(tooltip);
        if (bbe.getSpeed() == 0.0f || leftTick == 0) {
            return;
        }
        CCGLang.translate("tooltip.leftTime", new Object[0]).style(ChatFormatting.GRAY).add(CCGLang.number(ChatFormatting.GOLD, leftTick / 20)).space().add(CCGLang.seconds().style(ChatFormatting.GRAY)).forGoggles(tooltip);
    }
}

