/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.goggles;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.filter.AttributeFilterWhitelistMode;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.forgestove.create_cyber_goggles.CCG;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilterItem.class})
public abstract class FilterItemMixin {
    @Inject(method={"makeSummary"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeSummary(ItemStack filter, CallbackInfoReturnable<List<Component>> returnable) {
        String address;
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return;
        }
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (filter.isComponentsPatchEmpty()) {
            returnable.setReturnValue(list);
            return;
        }
        if (filter.getItem().equals(AllItems.FILTER.get())) {
            ItemStackHandler filterItems = FilterItem.getFilterItems((ItemStack)filter);
            boolean blacklist = (Boolean)filter.getOrDefault(AllDataComponents.FILTER_ITEMS_BLACKLIST, (Object)false);
            list.add((blacklist ? CreateLang.translateDirect((String)"gui.filter.deny_list", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.filter.allow_list", (Object[])new Object[0])).withStyle(ChatFormatting.GOLD));
            int count = 0;
            for (int i = 0; i < filterItems.getSlots(); ++i) {
                ItemStack filterStack = filterItems.getStackInSlot(i);
                if (filterStack.isEmpty()) continue;
                list.add(Component.literal((String)"- ").append(filterStack.getHoverName()).withStyle(ChatFormatting.GRAY));
                ++count;
            }
            if (count == 0) {
                returnable.setReturnValue(Collections.emptyList());
                return;
            }
        } else if (filter.getItem().equals(AllItems.ATTRIBUTE_FILTER.get())) {
            AttributeFilterWhitelistMode whitelistMode = (AttributeFilterWhitelistMode)filter.get(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
            list.add((whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_conjunctive", (Object[])new Object[0]) : (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_disjunctive", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.attribute_filter.deny_list", (Object[])new Object[0]))).withStyle(ChatFormatting.GOLD));
            int count = 0;
            for (ItemAttribute.ItemAttributeEntry attributeEntry : (List)filter.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, new ArrayList())) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute == null) continue;
                list.add(Component.literal((String)"- ").append((Component)attribute.format(attributeEntry.inverted())));
                ++count;
            }
            if (count == 0) {
                returnable.setReturnValue(Collections.emptyList());
                return;
            }
        } else if (filter.getItem().equals(AllItems.PACKAGE_FILTER.get()) && !(address = PackageItem.getAddress((ItemStack)filter)).isBlank()) {
            list.add(CreateLang.text((String)"-> ").style(ChatFormatting.GRAY).add(CreateLang.text((String)address).style(ChatFormatting.GOLD)).component());
        }
        returnable.setReturnValue(list);
    }
}

