/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.mixin.provider;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.OutlineRenderer;
import io.github.forgestove.create_cyber_goggles.core.util.IOutlineRenderable;
import io.github.forgestove.create_cyber_goggles.core.util.TooltipUtil;
import java.util.List;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={NozzleBlockEntity.class})
public abstract class NozzleBlockEntityMixin
extends SmartBlockEntity
implements IHaveGoggleInformation,
IOutlineRenderable {
    @Shadow
    private boolean pushing;
    @Shadow
    private float range;

    public NozzleBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!CCG.CONFIG.goggles.enhancedInfo) {
            return false;
        }
        return TooltipUtil.addFanTooltip(tooltip, this.pushing, this.range, 2);
    }

    @Override
    public void ccg$render() {
        Vec3 center = this.getBlockPos().getCenter();
        int color = OutlineRenderer.getColor(this.pushing);
        Outliner.getInstance().chaseAABB((Object)("NozzleAirBox" + String.valueOf(this)), new AABB(center, center).inflate((double)(this.range / 2.0f))).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        int numberOfFlowBoxes = OutlineRenderer.getNumberOfFlowBoxes(this.range);
        for (int i = 0; i < numberOfFlowBoxes; ++i) {
            double offset = OutlineRenderer.getOffset(i, numberOfFlowBoxes);
            String id = "NozzleAirFlowBox" + String.valueOf(this) + i;
            if (offset > 0.98) {
                Outliner.getInstance().remove((Object)id);
                continue;
            }
            double radius = this.pushing ? offset * (double)this.range / 2.0 : (1.0 - offset) * (double)this.range / 2.0;
            AABB flowBound = new AABB(center, center).inflate(radius);
            Outliner.getInstance().chaseAABB((Object)id, flowBound).withFaceTextures((BindableTexture)AllSpecialTextures.CHECKERED, (BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).colored(color);
        }
    }
}

