/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.IOutlineRenderable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public class OutlineRenderer {
    public static final Map<BlockEntity, Integer> cachedBE = new HashMap<BlockEntity, Integer>();

    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (!CCG.CONFIG.outlineRenderer.renderAnalogBox) {
            return;
        }
        if (CCGUtil.mc.level == null) {
            cachedBE.clear();
            return;
        }
        if (CCGUtil.mc.isPaused() || CCGUtil.isInGUI()) {
            return;
        }
        BlockEntity be = CCGUtil.getBlockEntity();
        if (be instanceof IOutlineRenderable) {
            cachedBE.put(be, CCG.CONFIG.outlineRenderer.delayRenderDuration);
        }
        if (cachedBE.isEmpty()) {
            return;
        }
        cachedBE.entrySet().removeIf(entry -> {
            int newValue = (Integer)entry.getValue() - 1;
            entry.setValue(newValue);
            BlockEntity key = (BlockEntity)entry.getKey();
            if (!key.isRemoved() && key instanceof IOutlineRenderable) {
                IOutlineRenderable ior = (IOutlineRenderable)key;
                ior.ccg$render();
            }
            return newValue <= 0;
        });
    }

    public static int getColor(boolean pushing) {
        return pushing ? CCG.CONFIG.outlineRenderer.windPushColor : CCG.CONFIG.outlineRenderer.windPullColor;
    }

    public static double getOffset(int i, int numberOfFlowBoxes) {
        return ((double)System.currentTimeMillis() + (double)i * (3000.0 / (double)numberOfFlowBoxes)) % 3000.0 / 3000.0;
    }

    public static int getNumberOfFlowBoxes(float range) {
        return (int)(Math.log(range) + 1.0);
    }
}

